/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.LBEnvelope;
import com.cognos.p2plb.config.ClusterManager;
import com.cognos.p2plb.core.MessageTimes;
import com.cognos.p2plb.model.ClusterView;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.p2plb.model.NodeView;
import com.cognos.p2plb.model.NodeViewPool;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class PingSkeleton
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PingSkeleton.class.getName());
    protected ClusterManager clusterManager;
    protected NodeViewPool node_pool;
    private PogoEngine pogoEngine;

    public PingSkeleton() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope request_env = (BIBusEnvelope)mc.getProperty("request.envelope");
        Element lbrequest = request_env.getBody().element(LBEnvelope.qn_p2plbPingRequest);
        if (lbrequest == null) {
            cat.info("bad ping received");
            mc.setFault(new Fault("invalid ping request, was ignored"));
            return;
        }
        String sourceGUID = request_env.getDispatcherTransportValue("sourceGUID");
        if (sourceGUID == null) {
            sourceGUID = "unknown";
        }
        String cluster_name = request_env.getDispatcherTransportValue("cluster_name");
        NodeID source_nid = NodeIdGuidMapper.getInstance().get(sourceGUID);
        if (source_nid == null) {
            cat.warn("ping request with bad sourceGUID: \"" + sourceGUID + "\"");
        }
        StringBuffer sb = null;
        if (cat.isDebugEnabled()) {
            sb = new StringBuffer();
            sb.append("received ping of cluster \"").append(cluster_name == null ? "<null>" : cluster_name).append("\" from node ").append(source_nid == null ? "<null>" : source_nid.toString());
            cat.debug(sb.toString());
        }
        ClusterView cv = null;
        if (cluster_name != null && cluster_name.length() > 0) {
            cv = this.clusterManager.getClusterView(cluster_name);
        }
        MessageTimes message_times = new MessageTimes();
        message_times.fromString(request_env.getDispatcherTransportValue("p2plb_messagetimes"));
        message_times.setDestIn(mc.getArrivalTime());
        BIBusEnvelope response_env = new BIBusEnvelope();
        Element eresp = response_env.getBody().addElement(LBEnvelope.qn_p2plbPingResponse);
        eresp.addAttribute("status", "ok");
        String result = null;
        result = !this.pogoEngine.getReadyToProcess() ? "notReady" : (cluster_name == null || cluster_name.length() == 0 ? "ok" : (cv == null ? "unknown" : "ok"));
        response_env.setDispatcherTransport("p2plb_result", result);
        InternetHeaders hdrs = new InternetHeaders();
        hdrs.setHeader("Content-Type", "text/xml; charset=utf-8");
        mc.setProperty("response.headers", hdrs);
        mc.setProperty("response.envelope", response_env);
        mc.setProperty("response.attachments", null);
        mc.setProperty("response.boundary", null);
        mc.setProperty("response.status_code", "200");
        mc.setProperty("response.status_msg", "OK");
        message_times.setDestOut();
        response_env.setDispatcherTransport("p2plb_messagetimes", message_times.toString());
        try {
            NodeView nv;
            mc.respond("response");
            if (source_nid != null && (nv = this.node_pool.get(source_nid)) != null) {
                this.node_pool.nodeIsWell(nv);
            }
        }
        catch (Exception x) {
            cat.debug("error occured responding to ping.", (Throwable)x);
        }
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.pogoEngine = engine;
    }

    @Override
    public void initialize() {
        this.clusterManager = (ClusterManager)this.pogoEngine.getContextAttribute("com.cognos.p2plb.clusterManager");
        if (this.clusterManager == null) {
            cat.error("logic error: cluster manager must be in context before this handler is initialized.");
            return;
        }
        this.node_pool = this.clusterManager.getNodePool();
    }
}

