/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.TestMsgGUIDBase;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class TestMsgDestGUIDHandler
extends TestMsgGUIDBase {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(TestMsgDestGUIDHandler.class.getName());

    public TestMsgDestGUIDHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope env_request = (BIBusEnvelope)mc.getProperty("request.envelope");
        String targetGUID = env_request.getDispatcherTransportValue("targetGUID");
        if (targetGUID == null) {
            cat.error("received message that does not have targetGUID");
            return;
        }
        String myGUID = NodeID.getSelf().getGuid();
        if (!myGUID.equals(targetGUID)) {
            if (cat.isErrorEnabled() && this.shouldLog(targetGUID)) {
                StringBuffer sb = new StringBuffer();
                sb.append("Received request from a dispatcher that knows me by a different GUID.").append("It sent GUID=\"").append(targetGUID).append("\".").append(" My GUID is \"").append(myGUID).append("\".").append(" This likely means I am registered in more than one ContentStore.").append(" Will reply with a fault.");
                cat.error(sb.toString());
            } else if (cat.isDebugEnabled()) {
                cat.debug("reply with fault to request from dispatcher that knows by a different GUID.");
            }
            Fault f = new Fault("TARGET_GUID_MISMATCH");
            f.addDetail("Message refused, source of ping knows me by a different GUID.");
            mc.setFault(f);
            return;
        }
    }
}

