/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.util.Calendar;
import java.util.HashSet;
import org.apache.log.Logger;

public abstract class TestMsgGUIDBase
extends BasicHandler {
    protected int logPeriodHours;
    protected Calendar logExpiry;
    protected HashSet<String> loggedForGUID = new HashSet();
    private Logger cat;

    public TestMsgGUIDBase(Logger cat) {
        super(cat);
        this.cat = cat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldLog(String sourceGUID) {
        if (this.logPeriodHours == 0) {
            return true;
        }
        TestMsgGUIDBase testMsgGUIDBase = this;
        synchronized (testMsgGUIDBase) {
            Calendar now = Calendar.getInstance();
            if (now.after(this.logExpiry)) {
                this.loggedForGUID.clear();
                this.bumpDate(now);
                this.logExpiry = now;
            }
            if (this.loggedForGUID.contains(sourceGUID)) {
                return false;
            }
            this.loggedForGUID.add(sourceGUID);
        }
        return true;
    }

    @Override
    public void start() {
        this.logExpiry = Calendar.getInstance();
        this.bumpDate(this.logExpiry);
    }

    protected void bumpDate(Calendar cal) {
        if (this.logPeriodHours > 0) {
            cal.add(11, this.logPeriodHours);
        }
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        String s = this.getRequiredAttribute(this.cat, "logFrequencyHours");
        try {
            this.logPeriodHours = Integer.parseInt(s);
        }
        catch (NumberFormatException nfx) {
            this.logPeriodHours = 24;
        }
        this.logPeriodHours = Math.min(this.logPeriodHours, 24);
        this.logPeriodHours = Math.max(this.logPeriodHours, 0);
        this.cat.debug("logFrequencyHours=" + this.logPeriodHours);
    }
}

