/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.TestMsgGUIDBase;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;

public class TestMsgSourceGUIDHandler
extends TestMsgGUIDBase {
    static final PogoLogger cat = PogoLogger.getLogger();

    public TestMsgSourceGUIDHandler() {
        super(cat.getNativeLogger());
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        boolean found;
        BIBusEnvelope env_request = (BIBusEnvelope)mc.getProperty("request.envelope");
        String sourceGUID = env_request.getDispatcherTransportValue("sourceGUID");
        if (sourceGUID == null) {
            sourceGUID = "--null--";
            found = false;
        } else {
            boolean bl = found = null != NodeIdGuidMapper.getInstance().get(sourceGUID);
        }
        if (!found) {
            if (cat.isInfoEnabled() && this.shouldLog(sourceGUID)) {
                cat.info("Received request from dispatcher: \"", sourceGUID, "\". I cannot resolve that dispatcher's GUID.", " This likely means we are running against", " different content stores, and I am registered in both.", " There is likely on old/incorrect registration for me", " in the other content store.  Will reply with a fault.");
            } else if (cat.isDebugEnabled()) {
                cat.debug("Reply with fault to request from unknown dispatcher: " + sourceGUID);
                cat.debug(NodeIdGuidMapper.getInstance().toString());
            }
            Fault f = new Fault("UNKNOWN_SOURCE_GUID");
            f.setMessageParameters(new Object[]{sourceGUID});
            f.addDetail("Request refused, GUID of source is unknown.");
            mc.setFault(f);
            return;
        }
    }
}

