/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.ConnectionPoolMap;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.http.httpclient.RawPostMethod;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class TimeoutPostMethod
extends RawPostMethod {
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(TimeoutPostMethod.class.getName());
    private final ConnectionPoolMap poolMap;
    private final NodeID nodeId;
    private int timeoutChecks;

    public TimeoutPostMethod(ConnectionPoolMap poolMap, NodeID nodeId, int timeoutChecks) {
        this.poolMap = poolMap;
        this.nodeId = nodeId;
        this.timeoutChecks = timeoutChecks;
    }

    protected void readStatusLine(HttpState state, HttpConnection conn) throws IOException, HttpException {
        while (true) {
            try {
                category.debug("About to read status line");
                super.readStatusLine(state, conn);
                category.debug("Complete reading status line");
                return;
            }
            catch (InterruptedIOException ex) {
                String conDetail = this.getConnectionDetail(state, conn);
                category.debug("readStatusLine InterruptedIOException: " + ex.toString() + "\t" + conDetail);
                if (!this.checkTimeout()) continue;
                category.debug("TimeoutPostMethod InterruptedIOException rethrown");
                throw ex;
            }
            catch (IOException ex) {
                category.debug("readStatusLine IOException: " + ex.toString());
                throw ex;
            }
            break;
        }
    }

    private String getConnectionDetail(HttpState state, HttpConnection conn) {
        String ret = "";
        if (conn.getProtocol() != null) {
            ret = ret + "protocol:" + conn.getProtocol().toString() + ",";
        }
        ret = ret + "host:" + conn.getHost() + ",";
        ret = ret + "port:" + String.valueOf(conn.getPort()) + ",";
        if (conn.getParams() != null) {
            ret = ret + "socketTimeout:" + String.valueOf(conn.getParams().getSoTimeout()) + ",";
        }
        ret = ret + "isOpen:" + String.valueOf(conn.isOpen()) + ",";
        if (conn.getLocalAddress() != null) {
            ret = ret + "localAddress:" + conn.getLocalAddress().toString() + ",";
        }
        ret = ret + "state:" + state.toString();
        return ret;
    }

    private boolean checkTimeout() {
        if (this.poolMap.checkConnection(this.nodeId)) {
            return false;
        }
        return --this.timeoutChecks <= 0;
    }
}

