/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver.actions;

import com.cognos.p2plb.clerver.actions.ForwardingParams;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.axis.utils.StringUtils;
import org.dom4j.Element;

public class BalancingParameters {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String FORWARDING_PARAMS = "ForwardingParams";
    private static final String SOAP_ACTIONS = "SoapActions";
    private static final String[] attributeNames = new String[]{"SoapActions", "ForwardingParams"};
    private String dispatcherName;
    private String hostPortAndContext;
    private String serviceName;
    private ForwardingParams forwardingParams;
    private String[] soapActions;

    public BalancingParameters(Element service) {
        ArrayList<String> soapActionList = new ArrayList<String>();
        this.serviceName = service.attributeValue("name");
        log.debug("Processing configuration for service: ", this.serviceName);
        this.forwardingParams = new ForwardingParams(this.serviceName, service);
        Iterator itSOAPAction = service.elementIterator("soapAction");
        while (itSOAPAction.hasNext()) {
            Element eSOAPAction = (Element)itSOAPAction.next();
            String soapAction = this.getSoapPath(eSOAPAction);
            soapActionList.add(soapAction);
        }
        this.soapActions = new String[soapActionList.size()];
        for (int i = 0; i < this.soapActions.length; ++i) {
            this.soapActions[i] = (String)soapActionList.get(i);
        }
    }

    private String getSoapPath(Element soapAction) {
        String soapPath = soapAction.attributeValue("path");
        return StringUtils.isEmpty((String)soapPath) ? soapAction.getTextTrim() : soapPath;
    }

    public BalancingParameters(MBeanServerConnection server, ObjectName objectName) {
        this(server, objectName.getKeyProperty("service"), objectName);
    }

    public BalancingParameters(MBeanServerConnection server, String serviceName, ObjectName objectName) {
        this.serviceName = serviceName;
        String dispatcherKeyProperty = objectName.getKeyProperty("dispatcher");
        this.dispatcherName = dispatcherKeyProperty == null ? null : ObjectName.unquote(dispatcherKeyProperty);
        try {
            AttributeList attributes = server.getAttributes(objectName, attributeNames);
            for (Attribute attr : attributes) {
                if (SOAP_ACTIONS.equals(attr.getName())) {
                    this.soapActions = (String[])attr.getValue();
                }
                if (!FORWARDING_PARAMS.equals(attr.getName())) continue;
                CompositeData composite = (CompositeData)attr.getValue();
                this.forwardingParams = new ForwardingParams(composite);
            }
        }
        catch (Exception e) {
            log.warn("Exception while getting remote balancing parameters for service " + serviceName + " : ", e);
        }
    }

    public static BalancingParameters createInstanceForTesting(String dispatcherName, String serviceName, ForwardingParams forwardingParams, String ... soapActions) {
        return new BalancingParameters(dispatcherName, serviceName, forwardingParams, soapActions);
    }

    private BalancingParameters(String dispatcherName, String serviceName, ForwardingParams forwardingParams, String[] soapActions) {
        this.dispatcherName = dispatcherName;
        this.serviceName = serviceName;
        this.forwardingParams = forwardingParams;
        this.soapActions = soapActions;
    }

    public String getDispatcherName() {
        return this.dispatcherName;
    }

    public String getHostPortAndContext() {
        if (this.hostPortAndContext == null) {
            this.hostPortAndContext = this.extractHostPortAndContextFromDispatcherName();
        }
        return this.hostPortAndContext;
    }

    private String extractHostPortAndContextFromDispatcherName() {
        if (StringUtils.isEmpty((String)this.dispatcherName)) {
            return this.dispatcherName;
        }
        NodeID nodeID = NodeID.getNodeID(this.dispatcherName);
        return nodeID != null ? nodeID.getHostPortAndContext() : this.dispatcherName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ForwardingParams getForwardingParams() {
        return this.forwardingParams;
    }

    public String[] getSoapActions() {
        return this.soapActions;
    }

    public List<String> getSoapActionList() {
        ArrayList<String> list = new ArrayList<String>();
        for (String soapAction : this.getSoapActions()) {
            list.add(soapAction);
        }
        return list;
    }

    public boolean isValid() {
        return this.soapActions != null && this.forwardingParams != null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + "dispatcherName=" + this.dispatcherName + ", " + "serviceName=" + this.serviceName + ", " + "forwardingParams=" + this.forwardingParams + ", " + "soapActions=" + this.getSoapActionStrings() + ", " + ")";
    }

    private String getSoapActionStrings() {
        StringBuilder sb = new StringBuilder("SoapActions(");
        for (String soapAction : this.soapActions) {
            sb.append(soapAction).append(" ");
        }
        return sb.append(')').toString();
    }
}

