/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver.actions;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class ForwardingParams {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ForwardingParams.class.getName());
    private static final String RETRY_ON_NO_PROCESS = "retryOnNoProcess";
    private static final String MAX_ATTEMPTS = "maxAttempts";
    private static final String DELAY_BETWEEN_ATTEMPTS = "delayBetweenAttempts";
    private static final String PREFER_LOCAL = "preferLocal";
    private long delayBetweenAttempts = 0L;
    private int maxAttempts = 1;
    private boolean retryOnNoProcess = false;
    private boolean preferLocal = false;

    ForwardingParams(String serviceName, Element eService) {
        Element eForwarding = eService.element("forwarding");
        if (eForwarding == null) {
            cat.debug("Service " + serviceName + " has no forwarding element, use defaults: attempts=1, delay=0");
            return;
        }
        this.createMaxAttempts(eForwarding);
        this.extractProcessLocally(eForwarding);
        this.extractDelayBetweenAttempts(eForwarding);
        this.extractRetryOnNoProcess(eForwarding);
        cat.debug("configured values for service \"" + serviceName + "\": maxAttempts=" + this.maxAttempts + ", delayBetweenAttempts=" + this.delayBetweenAttempts + ", retryOnNoProcess=" + this.retryOnNoProcess + ", preferLocal=" + this.preferLocal);
    }

    private void extractProcessLocally(Element eForwarding) {
        this.preferLocal = this.getOptionalBoolean(eForwarding, PREFER_LOCAL);
    }

    private boolean getOptionalBoolean(Element eForwarding, String name) {
        String s = eForwarding.attributeValue(name);
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    private void extractRetryOnNoProcess(Element eForwarding) {
        this.retryOnNoProcess = this.getOptionalBoolean(eForwarding, RETRY_ON_NO_PROCESS);
    }

    private void extractDelayBetweenAttempts(Element eForwarding) {
        String s = eForwarding.attributeValue(DELAY_BETWEEN_ATTEMPTS);
        if (s == null) {
            cat.error("element has no \"delayBetweenAttempts\" attribute.  Assuming 0.");
        } else {
            try {
                this.delayBetweenAttempts = Integer.parseInt(s);
                this.delayBetweenAttempts = Math.max(this.delayBetweenAttempts, 0L);
            }
            catch (Exception x) {
                cat.error("invalid format for value of delayBetweenAttempts: \"" + s + "\", assuming 0");
            }
        }
    }

    private void createMaxAttempts(Element eForwarding) {
        String s = eForwarding.attributeValue(MAX_ATTEMPTS);
        if (s == null) {
            cat.error("element has no \"maxAttempts\" attribute.  Assuming 1.");
        } else {
            try {
                this.maxAttempts = Integer.parseInt(s);
                this.maxAttempts = Math.max(this.maxAttempts, 1);
            }
            catch (Exception x) {
                cat.error("invalid format for value of maxAttempts: \"" + s + "\", assuming 1");
            }
        }
    }

    ForwardingParams(CompositeData composite) {
        if (composite.containsKey(DELAY_BETWEEN_ATTEMPTS)) {
            this.delayBetweenAttempts = (Long)composite.get(DELAY_BETWEEN_ATTEMPTS);
        }
        if (composite.containsKey(MAX_ATTEMPTS)) {
            this.maxAttempts = (Integer)composite.get(MAX_ATTEMPTS);
        }
        if (composite.containsKey(RETRY_ON_NO_PROCESS)) {
            this.retryOnNoProcess = (Boolean)composite.get(RETRY_ON_NO_PROCESS);
        }
        if (composite.containsKey(PREFER_LOCAL)) {
            this.preferLocal = (Boolean)composite.get(PREFER_LOCAL);
        }
    }

    public static ForwardingParams createInstanceForTesting(long delay, int max, boolean retry) {
        return new ForwardingParams(delay, max, retry);
    }

    private ForwardingParams(long delay, int max, boolean retry) {
        this.delayBetweenAttempts = delay;
        this.maxAttempts = max;
        this.retryOnNoProcess = retry;
    }

    public long getDelayBetweenAttempts() {
        return this.delayBetweenAttempts;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public boolean getRetryOnNoProcess() {
        return this.retryOnNoProcess;
    }

    public boolean isPreferLocal() {
        return this.preferLocal;
    }

    public CompositeData getComposite() throws OpenDataException {
        String[] itemNames = new String[]{DELAY_BETWEEN_ATTEMPTS, MAX_ATTEMPTS, RETRY_ON_NO_PROCESS, PREFER_LOCAL};
        String[] itemDescs = new String[]{DELAY_BETWEEN_ATTEMPTS, MAX_ATTEMPTS, RETRY_ON_NO_PROCESS, PREFER_LOCAL};
        OpenType[] itemTypes = new OpenType[]{SimpleType.LONG, SimpleType.INTEGER, SimpleType.BOOLEAN, SimpleType.BOOLEAN};
        CompositeType compositeType = new CompositeType("forwardingParams", "forwardingParams", itemNames, itemDescs, itemTypes);
        Object[] values = new Object[]{new Long(this.delayBetweenAttempts), new Integer(this.maxAttempts), this.retryOnNoProcess, this.preferLocal};
        return new CompositeDataSupport(compositeType, itemNames, values);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + DELAY_BETWEEN_ATTEMPTS + " = " + this.delayBetweenAttempts + ", " + MAX_ATTEMPTS + " = " + this.maxAttempts + ", " + RETRY_ON_NO_PROCESS + " = " + this.retryOnNoProcess + ", " + PREFER_LOCAL + " = " + this.preferLocal + ")";
    }
}

