/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver.actions;

import com.cognos.p2plb.clerver.actions.BalancingParameters;
import com.cognos.p2plb.clerver.actions.ForwardingParams;
import com.cognos.p2plb.clerver.actions.SupportedSoapActions;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.services.DispatcherServices;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.dom4j.Element;

public class MapSoapActionToService {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final int NOT_FOUND = -1;
    private Map<String, String> mapSoapAction = new HashMap<String, String>();
    private HashMap<String, ForwardingParams> mapServiceToForwardingParam = new HashMap();
    private final Handler loadBalanceServiceHandler;
    private DispatcherServices dispatcherServices;
    private final SupportedSoapActions supportedSoapActions = new SupportedSoapActions();

    public MapSoapActionToService(Handler loadBalanceServiceHandler, DispatcherServices dispatcherServices) {
        this.loadBalanceServiceHandler = loadBalanceServiceHandler;
        this.dispatcherServices = dispatcherServices;
    }

    private void put(String soapAction, String serviceName) {
        this.mapSoapAction.put(soapAction, serviceName);
    }

    public String get(String soapAction) {
        String service = this.mapSoapAction.get(soapAction);
        return service != null ? service : this.getServiceForPreviousVersion(soapAction);
    }

    private String getServiceForPreviousVersion(String soapAction) {
        List<String> previousVersions = this.dispatcherServices.expandPreviousVersions(soapAction);
        for (String previousSoapAction : previousVersions) {
            String service = this.mapSoapAction.get(previousSoapAction);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public boolean containsKey(String soapAction) {
        return this.mapSoapAction.containsKey(soapAction);
    }

    public void interceptSoapActions(Element eServices) {
        Iterator serviceIt = eServices.elementIterator("service");
        while (serviceIt.hasNext()) {
            Element eService = (Element)serviceIt.next();
            BalancingParameters balancingParameters = new BalancingParameters(eService);
            this.addBalancing(balancingParameters);
        }
    }

    public void addBalancing(BalancingParameters balancingParameters) {
        cat.debug("addBalancing");
        this.addForwardingParameters(balancingParameters);
        this.addSoapActions(balancingParameters);
    }

    private void addForwardingParameters(BalancingParameters balancingParameters) {
        String serviceName = balancingParameters.getServiceName();
        cat.debug("addForwardingParameters: ", serviceName);
        if (!this.mapServiceToForwardingParam.containsKey(serviceName)) {
            this.mapServiceToForwardingParam.put(serviceName, balancingParameters.getForwardingParams());
        }
    }

    private void addSoapActions(BalancingParameters balancingParameters) {
        for (String soapAction : balancingParameters.getSoapActions()) {
            cat.debug("addSoapAction: ", soapAction);
            this.addMapping(soapAction, balancingParameters);
            this.supportedSoapActions.add(soapAction, balancingParameters.getHostPortAndContext());
        }
    }

    private synchronized void addMapping(String soapAction, BalancingParameters balancingParameters) {
        String serviceName = balancingParameters.getServiceName();
        if (soapAction.equals("")) {
            cat.debug("Ignoring empty soap action for service name: ", serviceName);
            return;
        }
        String hostAndPort = balancingParameters.getHostPortAndContext();
        List<Object> expandedSoapactions = new ArrayList();
        if (!this.containsKey(soapAction)) {
            cat.debug("add mapping from soapAction \"", soapAction, "\" to service \"", serviceName, "\"");
            this.put(soapAction, serviceName);
            expandedSoapactions = this.transferHandlersForSoapAction(soapAction);
        } else {
            expandedSoapactions = this.getAllSoapActionVersions(soapAction);
        }
        for (String string : expandedSoapactions) {
            cat.debug("add mapping from soapAction \"", string, "\" to service \"", serviceName, "\"");
            this.put(string, serviceName);
            this.supportedSoapActions.add(string, hostAndPort);
        }
    }

    private List<String> transferHandlersForSoapAction(String soapAction) {
        List<String> transferredSoapactions = this.dispatcherServices.transferSoapAction(soapAction, this.loadBalanceServiceHandler);
        if (transferredSoapactions.isEmpty()) {
            cat.warn("Soap action ", soapAction, " already transferred for load balancing. ");
        }
        return transferredSoapactions;
    }

    private List<String> getAllSoapActionVersions(String soapAction) {
        List<String> versionedSoapActions = this.dispatcherServices.getAllSoapActionVersions(soapAction);
        return versionedSoapActions;
    }

    public ForwardingParams getForwardingParams(String serviceName) {
        return this.mapServiceToForwardingParam.get(serviceName);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.dumpToString(buffer, this.mapSoapAction, "services", false);
        this.dumpToString(buffer, this.dispatcherServices.getHandlerMap(), "handlers", true);
        this.dumpToString(buffer, this.dispatcherServices.getHandlerMap(), "local handlers", false);
        this.dumpToString(buffer, this.dispatcherServices.getServiceMap(), "local services", false);
        this.dumpToString(buffer, this.mapServiceToForwardingParam, "forwarding parameters", false);
        this.supportedSoapActions.dumpToString(buffer);
        return buffer.toString();
    }

    private void dumpToString(StringBuilder buffer, Map<String, ?> map, String mapType, boolean skipNullValue) {
        buffer.append("Soap actions to ").append(mapType).append(": \n");
        for (String soapAction : this.getSortedKeySet(map)) {
            Object value = map.get(soapAction);
            if (skipNullValue && value == null) continue;
            buffer.append("   ").append(soapAction).append(" --> ").append(String.valueOf(value)).append("\n");
        }
    }

    private TreeSet<String> getSortedKeySet(Map<String, ?> map) {
        return new TreeSet<String>(map.keySet());
    }

    public List<String> getSoapActions() {
        return new ArrayList<String>(this.mapSoapAction.keySet());
    }

    public boolean isSoapActionSupported(String soapAction, String dispatcherName) {
        soapAction = this.stripHashedURL(soapAction);
        return this.supportedSoapActions.contains(soapAction, dispatcherName);
    }

    private String stripHashedURL(String soapAction) {
        int pos = soapAction.indexOf(35);
        return pos == -1 ? soapAction : soapAction.substring(pos + 1);
    }
}

