/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver.actions;

import com.cognos.p2plb.clerver.actions.BalancingParameters;
import com.cognos.p2plb.clerver.actions.MapSoapActionToService;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.updates.RemoteDispatcherUpdates;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.util.PogoLogger;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MapSoapActionToServiceUpdater
extends RemoteDispatcherUpdates {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final MapSoapActionToService mapSoapActionToService;
    private PogoMBeanServer pogoMBeanServer;

    public MapSoapActionToServiceUpdater(MapSoapActionToService map) {
        this(map, PogoMBeanServer.getInstance());
    }

    public MapSoapActionToServiceUpdater(MapSoapActionToService map, PogoMBeanServer server) {
        this.mapSoapActionToService = map;
        this.pogoMBeanServer = server;
    }

    private void getSoapActionsForDispatcher(String dispatcherName) {
        log.debug("getSoapActionsForDispatcher: ", dispatcherName);
        try {
            ObjectName pattern = MBeanUtils.getDispatcherPattern(dispatcherName, "Metrics");
            this.getSoapActionsForPattern(pattern, this.getMBeanServer(), false);
        }
        catch (MalformedObjectNameException e) {
            log.warn("Unable to get soap actions for dispatcher " + dispatcherName, e);
        }
    }

    private void getSoapActionsForPattern(ObjectName pattern, MBeanServer beanServer, boolean checkDispatcher) {
        log.debug("getSoapActionsForPattern");
        Set<ObjectName> objectNames = beanServer.queryNames(pattern, null);
        for (ObjectName objectName : objectNames) {
            if (!this.needToBalance(objectName, checkDispatcher)) continue;
            log.debug("needToBalance: ", objectName.getKeyProperty("service"));
            this.createAndAddBalancingParameters(beanServer, objectName);
        }
    }

    boolean needToBalance(ObjectName objectName, boolean checkDispatcher) {
        String serviceName = objectName.getKeyProperty("service");
        String dispatcherName = objectName.getKeyProperty("dispatcher");
        return serviceName != null && (!checkDispatcher || dispatcherName != null);
    }

    private void createAndAddBalancingParameters(MBeanServer beanServer, ObjectName objectName) {
        BalancingParameters balancingParameters = new BalancingParameters(beanServer, objectName);
        if (balancingParameters.isValid()) {
            log.debug("Adding remote balancing for service ", balancingParameters.getServiceName());
            this.mapSoapActionToService.addBalancing(balancingParameters);
        }
    }

    protected MBeanServer getMBeanServer() {
        return this.pogoMBeanServer.getProxyMBeanServer();
    }

    public void getMBeanActions() throws MalformedObjectNameException {
        log.debug("getMBeanActions");
        this.getSoapActionsForPattern(MBeanUtils.getAllServicesPattern("loadBalancing"), this.getLocalMBeanServer(), false);
        this.getSoapActionsForPattern(MBeanUtils.getAllServicesPattern("Metrics"), this.getMBeanServer(), true);
    }

    @Override
    public void updateDispatchers(String[] addedDispatchers, String[] removedDispatchers) {
        for (String dispatcher : addedDispatchers) {
            this.getSoapActionsForDispatcher(dispatcher);
        }
    }

    @Override
    public void update() {
        log.debug("update");
        this.notifyCheckProxyHandler();
        this.tryToGetMBeanSoapActions();
    }

    private void tryToGetMBeanSoapActions() {
        try {
            this.getMBeanActions();
        }
        catch (Exception e) {
            log.warn("Unable to get mbean soap actions from mbean server. ", e);
        }
    }
}

