/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver.actions;

import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StringUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SupportedSoapActions {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final char EOL = '\n';
    private final Set<String> staticSoapActions = new HashSet<String>();
    private final Map<String, Set<String>> remoteSoapActionsByDispatcher = new ConcurrentHashMap<String, Set<String>>();

    public void add(String soapAction, String hostAndPort) {
        if (hostAndPort == null) {
            this.addStaticSoapAction(soapAction);
        } else {
            this.addRemoteSoapAction(soapAction, hostAndPort);
        }
    }

    private void addStaticSoapAction(String soapAction) {
        log.debug("Adding static soap action [", soapAction, "]");
        this.staticSoapActions.add(soapAction.intern());
    }

    private void addRemoteSoapAction(String soapAction, String hostAndPort) {
        log.debug("Adding remote soap action [", soapAction, "] as supported by [", hostAndPort, "]");
        Set<String> soapActions = this.getOrCreateRemoteSoapActions(hostAndPort);
        soapActions.add(soapAction.intern());
    }

    private Set<String> getOrCreateRemoteSoapActions(String hostAndPort) {
        Set<String> soapActions = this.getRemoteSoapActions(hostAndPort);
        if (soapActions == null) {
            soapActions = this.createRemoteSoapActions(hostAndPort);
        }
        return soapActions;
    }

    private Set<String> getRemoteSoapActions(String hostAndPort) {
        return this.remoteSoapActionsByDispatcher.get(hostAndPort);
    }

    private Set<String> createRemoteSoapActions(String hostAndPort) {
        Set<String> soapActions = Collections.synchronizedSet(new HashSet());
        this.remoteSoapActionsByDispatcher.put(hostAndPort, soapActions);
        return soapActions;
    }

    public boolean contains(String soapAction, String hostAndPort) {
        log.debug("Checking soap action [", soapAction, "] on [", hostAndPort, "]");
        return this.isStaticSoapAction(soapAction) || this.isRemoteSoapAction(soapAction, hostAndPort);
    }

    private boolean isStaticSoapAction(String soapAction) {
        return this.staticSoapActions.contains(StringUtils.stripQuotes(soapAction));
    }

    private boolean isRemoteSoapAction(String soapAction, String hostAndPort) {
        Set<String> soapActions = this.getRemoteSoapActions(hostAndPort);
        return soapActions != null && soapActions.contains(StringUtils.stripQuotes(soapAction));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dumpToString(sb);
        return sb.toString();
    }

    public void dumpToString(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName()).append('\n');
        this.appendSoapActions(sb, "   Static soap actions", this.staticSoapActions);
        for (String node : this.remoteSoapActionsByDispatcher.keySet()) {
            this.appendSoapActions(sb, "   Remote soap actions for " + node, this.remoteSoapActionsByDispatcher.get(node));
        }
    }

    private void appendSoapActions(StringBuilder sb, String title, Set<String> soapActions) {
        sb.append(title).append('\n');
        for (String soapAction : soapActions) {
            sb.append("      ").append(soapAction).append('\n');
        }
    }
}

