/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver.balancer;

import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.CamProtect;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.dom4j.Dom4jEnvelope;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.internal.ombridge.BridgeHandler;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Document;

public class OMBridgeHelper {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String REQUEST_ENVELOPE = "request.envelope";
    private static final String RESPONSE_ENVELOPE = "response.envelope";
    private static final String COLORADO_VERSION = "201012";
    private String latestVersion;
    private CryptoFacility cryptoFacility;

    public OMBridgeHelper() {
        this(new CryptoFacility());
    }

    public OMBridgeHelper(CryptoFacility cryptoFacility) {
        this.cryptoFacility = cryptoFacility;
        this.loadLatestVersion();
    }

    protected void loadLatestVersion() {
        List<String> supportedVersions = this.getSupportedVersions();
        this.latestVersion = supportedVersions.get(0);
    }

    public OMBridgeHelper(String version) {
        this.latestVersion = version;
    }

    public OMBridgeHelper(CryptoFacility cryptoFacility, String version) {
        this.latestVersion = version;
        this.cryptoFacility = cryptoFacility;
    }

    public BIBusEnvelope bridgeRequest(MessageContext mc) {
        return this.bridgeRequest(mc, this.latestVersion);
    }

    public BIBusEnvelope bridgeRequest(MessageContext mc, String version) {
        BIBusEnvelope originalEnvelope = this.copyHeaderToNewEnvelope(mc);
        String bridgeVersion = this.mapEditionToSoapActionVersion(version);
        this.bridgeRequest(mc, this.latestVersion, bridgeVersion);
        BIBusEnvelope bridgedEnvelope = this.swapEnvelope(mc, originalEnvelope);
        return bridgedEnvelope;
    }

    protected String mapEditionToSoapActionVersion(String version) {
        return BridgeHandler.mapEditionToSoapActionVersion((String)version);
    }

    public void bridgeRequest(MessageContext mc, String incoming, String outgoing) {
        BIBusEnvelope envelope = this.getRequestEnvelope(mc);
        SOAPEnvelope bridgedRequest = this.bridgeRequest(envelope, incoming, outgoing);
        this.putRequestEnvelope(mc, bridgedRequest);
    }

    BIBusEnvelope copyHeaderToNewEnvelope(MessageContext mc) {
        BIBusEnvelope originalEnvelope = this.getRequestEnvelope(mc);
        BIBusEnvelope target = originalEnvelope.newBIBusEnvelope();
        originalEnvelope.copyBiBusHeaderTo(target);
        this.putRequestEnvelope(mc, target);
        return originalEnvelope;
    }

    private BIBusEnvelope swapEnvelope(MessageContext mc, BIBusEnvelope originalEnvelope) {
        BIBusEnvelope bridgedEnvelope = this.getRequestEnvelope(mc);
        bridgedEnvelope.copyBiBusHeaderTo(originalEnvelope);
        this.putRequestEnvelope(mc, originalEnvelope);
        return originalEnvelope;
    }

    private BIBusEnvelope getRequestEnvelope(MessageContext mc) {
        return (BIBusEnvelope)mc.getProperty(REQUEST_ENVELOPE);
    }

    private void putRequestEnvelope(MessageContext mc, Envelope target) {
        if (target != null) {
            mc.setProperty(REQUEST_ENVELOPE, target);
        }
    }

    private BIBusEnvelope getResponseEnvelope(MessageContext mc) {
        return (BIBusEnvelope)mc.getProperty(RESPONSE_ENVELOPE);
    }

    private void putResponseEnvelope(MessageContext mc, Envelope target) {
        mc.setProperty(RESPONSE_ENVELOPE, target);
    }

    public void bridgeResponse(MessageContext mc) {
        this.bridgeResponse(mc, this.latestVersion, COLORADO_VERSION);
    }

    public void bridgeResponse(MessageContext mc, String version) {
        String bridgeVersion = this.mapEditionToSoapActionVersion(version);
        this.bridgeResponse(mc, this.latestVersion, bridgeVersion);
    }

    public void bridgeResponse(MessageContext mc, String incoming, String outgoing) {
        BIBusEnvelope biBusEnvelope = this.getResponseEnvelope(mc);
        if (biBusEnvelope != null) {
            SOAPEnvelope bridgedResponse = this.bridgeResponse(biBusEnvelope, incoming, outgoing);
            try {
                this.putResponseEnvelope(mc, biBusEnvelope.fromDom4j((BIBusEnvelope)bridgedResponse));
            }
            catch (Exception e) {
                log.warn("Exception converting envelope.  Bridging not done ", e);
            }
        }
    }

    public List<String> getSupportedVersions() {
        try {
            List<String> supportedVersions = BridgeHandler.getSupportedVersions();
            return supportedVersions.size() > 0 ? supportedVersions : this.getTestSupportedVersions();
        }
        catch (NoClassDefFoundError e) {
            return this.getTestSupportedVersions();
        }
    }

    protected List<String> getTestSupportedVersions() {
        String[] versions = new String[]{"201301", "201109"};
        return Arrays.asList(versions);
    }

    public SOAPEnvelope bridgeRequest(BIBusEnvelope biBusEnvelope, String srcVersion, String dstVersion) {
        String serviceID = this.getMessageTrust(biBusEnvelope);
        SOAPEnvelope bridgedEnvelope = this.processMessage(biBusEnvelope, srcVersion, dstVersion);
        if (serviceID != null) {
            return this.setMessageTrust(bridgedEnvelope, serviceID);
        }
        try {
            return biBusEnvelope.fromDom4j((BIBusEnvelope)bridgedEnvelope);
        }
        catch (Exception e) {
            log.warn("Exception converting envelope.  Bridging not done ", e);
            return null;
        }
    }

    public SOAPEnvelope bridgeResponse(BIBusEnvelope biBusEnvelope, String srcVersion, String dstVersion) {
        return this.processMessage(biBusEnvelope, srcVersion, dstVersion);
    }

    private SOAPEnvelope processMessage(BIBusEnvelope biBusEnvelope, String srcVersion, String dstVersion) {
        try {
            BIBusEnvelope dom4jEnvelope = (BIBusEnvelope)biBusEnvelope.toDom4j();
            return this.bridgeUsingDocument(dom4jEnvelope, srcVersion, dstVersion);
        }
        catch (Exception e) {
            log.warn("Exception converting envelope. Bridging not done ", e);
            return biBusEnvelope;
        }
    }

    protected Dom4jEnvelope bridgeUsingDocument(BIBusEnvelope dom4jEnvelope, String srcVersion, String dstVersion) {
        Document doc = dom4jEnvelope.getAsDocument();
        BridgeHandler.processMessage((Document)doc, (String)srcVersion, (String)dstVersion, (String)dom4jEnvelope.getPassportID());
        return new Dom4jEnvelope(doc);
    }

    private String getMessageTrust(BIBusEnvelope biBusEnvelope) {
        String serviceID = null;
        CamProtect camProtect = biBusEnvelope.getBiBusHeader().getCamProtect();
        if (camProtect.isPresent()) {
            try {
                byte[] buf = biBusEnvelope.getAsBytesForSignatureCheck();
                if (this.cryptoFacility.isContentSigned(buf)) {
                    serviceID = camProtect.getServiceId();
                    camProtect.clear();
                }
            }
            catch (Exception e) {
                log.warn("Error getting message trust", e);
                return null;
            }
        }
        return serviceID;
    }

    private BIBusEnvelope setMessageTrust(SOAPEnvelope bridgedEnvelope, String serviceID) {
        try {
            byte[] msg = bridgedEnvelope.getAsBytesForSignatureCheck();
            byte[] trustedRequest = this.cryptoFacility.signTrustedRequest(msg, serviceID);
            return new BIBusEnvelope(new ByteArrayInputStream(trustedRequest));
        }
        catch (Exception e) {
            log.warn("Cannot bridge SOAP message", e);
            return null;
        }
    }
}

