/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.config;

import com.cognos.p2plb.config.ConfiguredCluster;
import com.cognos.p2plb.model.ClusterView;
import com.cognos.p2plb.model.NodeViewPool;
import com.cognos.p2plb.util.ActionQueue;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;
import java.util.HashMap;

public class ClusterManager {
    static final PogoLogger cat = PogoLogger.getLogger();
    private HashMap<String, ConfiguredCluster> mapConfiguredClusters = new HashMap();
    private ActionQueue actionQueue;
    private NodeViewPool nodePool;
    private ConfiguredCluster globalConfiguredCluster;

    public ClusterManager(NodeViewPool nodePool, ActionQueue actionQueue) {
        this.nodePool = nodePool;
        this.actionQueue = actionQueue;
    }

    public synchronized ClusterView getClusterView(String clusterName) {
        ConfiguredCluster cc = this.getConfiguredCluster(clusterName);
        if (cc == null) {
            cat.warn("cluster name: \"" + clusterName + "\" has not been configured.");
            return null;
        }
        return cc.getClusterView();
    }

    public ConfiguredCluster getConfiguredCluster(String clusterName) {
        return this.mapConfiguredClusters.get(clusterName);
    }

    public ClusterView getGlobalClusterView() {
        if (this.globalConfiguredCluster == null) {
            cat.warn("global configured cluster has not been configured.");
            return null;
        }
        return this.globalConfiguredCluster.getClusterView();
    }

    private synchronized void setClusterConfig(String clusterName, Configuration configuration) {
        cat.debug("setClusterConfig: ", clusterName);
        ConfiguredCluster cc = this.getOrCreateConfiguredCluster(clusterName);
        cc.setConfiguration(configuration);
    }

    private ConfiguredCluster getOrCreateConfiguredCluster(String clusterName) {
        ConfiguredCluster cc = this.getConfiguredCluster(clusterName);
        if (cc == null) {
            cc = this.createConfiguredCluster(clusterName);
        }
        return cc;
    }

    private ConfiguredCluster createConfiguredCluster(String clusterName) {
        cat.debug("createConfiguredCluster: ", clusterName);
        ConfiguredCluster cc = new ConfiguredCluster(this, clusterName);
        this.mapConfiguredClusters.put(clusterName, cc);
        return cc;
    }

    public synchronized void createClusterFromConfiguration(Configuration configuration) {
        DispatcherList dispatcherList = (DispatcherList)configuration.getDispatcherList();
        for (String serverGroup : dispatcherList.getServerGroups()) {
            this.setClusterConfig(serverGroup, configuration);
        }
        this.setGlobalClusterConfig(configuration);
    }

    private void setGlobalClusterConfig(Configuration configuration) {
        if (this.globalConfiguredCluster == null) {
            this.globalConfiguredCluster = new ConfiguredCluster(this, null);
        }
        this.globalConfiguredCluster.setConfiguration(configuration);
    }

    public void setglobalConfiguredClusterForTesting(ConfiguredCluster configuredCluster) {
        this.globalConfiguredCluster = configuredCluster;
    }

    public void setClusterConfigForTesting(String clusterName, Configuration configuration) {
        this.setClusterConfig(clusterName, configuration);
    }

    public NodeViewPool getNodePool() {
        return this.nodePool;
    }

    ActionQueue getActionQueue() {
        return this.actionQueue;
    }
}

