/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.config;

import com.cognos.p2plb.config.ClusterManager;
import com.cognos.p2plb.model.ClusterView;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListConfiguration;
import com.cognos.pogo.pdk.Configuration;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ConfiguredCluster {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ConfiguredCluster.class.getName());
    private ClusterManager clusterManager;
    private String name;
    private Configuration currentConfiguration = null;
    private ClusterView clusterView = null;
    private DispatcherListConfiguration currentDispatcherListConfiguration;

    public ConfiguredCluster(ClusterManager clusterManager, String name) {
        this.clusterManager = clusterManager;
        this.name = name;
    }

    public synchronized boolean setConfiguration(Configuration newConfiguration) {
        if (!this.configurationChanged(newConfiguration)) {
            return false;
        }
        cat.debug("setConfiguration: cluster topology has changed");
        this.currentConfiguration = newConfiguration;
        if (this.clusterView != null) {
            cat.debug("retiring cluster view.");
            this.clusterView.retire();
            this.clusterView = null;
        }
        this.getClusterView();
        return true;
    }

    private boolean configurationChanged(Configuration newConfiguration) {
        DispatcherList newDispatcherList = (DispatcherList)newConfiguration.getDispatcherList();
        DispatcherListConfiguration newDispatcherListConfiguration = newDispatcherList.getDispatcherListConfiguration();
        if (this.currentDispatcherListConfiguration != null && this.currentDispatcherListConfiguration.equals(newDispatcherListConfiguration)) {
            cat.debug("Cluster topology is unchanged. Updating cluster view parameters.");
            this.clusterView.updateConfiguration(newConfiguration);
            return false;
        }
        this.currentDispatcherListConfiguration = newDispatcherListConfiguration;
        return true;
    }

    public synchronized ClusterView getClusterView() {
        if (this.clusterView == null) {
            if (this.currentConfiguration == null) {
                cat.debug("cluster configuration not available yet.");
                return null;
            }
            cat.debug("Preparing new ClusterView from configuration.");
            this.clusterView = this.createClusterView();
            this.clusterView.prepareFromCfig(this.currentConfiguration);
        }
        return this.clusterView;
    }

    protected ClusterView createClusterView() {
        return new ClusterView(this.name, this.clusterManager.getNodePool(), this.clusterManager.getActionQueue());
    }

    protected String getName() {
        return this.name;
    }

    protected ClusterManager getClusterManager() {
        return this.clusterManager;
    }
}

