/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.model;

import com.cognos.pogo.util.InetAddressFactory;
import com.cognos.pogo.util.PogoLogger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log.Priority;

public class NodeID
implements Comparable<Object> {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static InetAddressFactory inetAddressFactory = new InetAddressFactory();
    private static NodeID selfnid;
    private static NodeID alternateSelfnid;
    private String protocol = "http";
    private String host_name;
    private int port;
    private String path;
    private String guid;
    private InetAddress inet_addr;
    private String toString;
    private String hostPortAndContext;
    private String inet_string_form;
    private String cmStatus;
    private String context;
    private String servletPath;

    public static NodeID getNodeID(String host_port_path) {
        if (StringUtils.isEmpty((String)host_port_path)) {
            return null;
        }
        try {
            return new NodeID(host_port_path);
        }
        catch (Exception x) {
            cat.debug("bad node id string: ", host_port_path);
            return null;
        }
    }

    public static NodeID getNodeID(String host, int port, String path) {
        return new NodeID(host, port, path);
    }

    private NodeID(String host, int port, String path) {
        this.host_name = host.toLowerCase();
        this.port = port;
        this.setPath(path);
        this.createStringRepresentations();
    }

    private void createStringRepresentations() {
        String hostAndPort = this.host_name + ":" + this.port;
        this.hostPortAndContext = hostAndPort + this.context;
        this.toString = hostAndPort + this.path;
    }

    public String toString() {
        return this.toString;
    }

    public String getHostPortAndContext() {
        return this.hostPortAndContext;
    }

    private NodeID(String uri) throws Exception {
        if (uri == null) {
            throw new Exception("null node id string");
        }
        StringTokenizer st = new StringTokenizer(uri, ":/");
        String next = st.nextToken();
        if (next.startsWith("http")) {
            this.protocol = next;
            next = st.nextToken();
        }
        if (next.startsWith("[")) {
            this.host_name = next;
            next = st.nextToken("]");
            this.host_name = this.host_name + next + "]";
            next = st.nextToken(":/");
        } else {
            this.host_name = next;
        }
        this.port = Integer.parseInt(st.nextToken());
        this.setPath(st.nextToken(""));
        this.createStringRepresentations();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String p) {
        this.protocol = p;
    }

    public String getHost() {
        return this.host_name;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    private void setPath(String path) {
        this.path = path;
        int slash = path.indexOf("/", 1);
        if (slash == -1) {
            slash = path.length();
        }
        this.context = path.substring(0, slash);
        this.servletPath = path.substring(slash);
    }

    public String getContext() {
        return this.context;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getHostInetAddress() {
        NodeID nodeID = this;
        synchronized (nodeID) {
            if (this.inet_addr == null) {
                this.resolveHostInetAddress();
            }
            return this.inet_addr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolveHostInetAddress() {
        InetAddress new_inet_addr = null;
        try {
            new_inet_addr = inetAddressFactory.getByName(this.host_name);
        }
        catch (UnknownHostException uhx) {
            cat.debug("cannot resolve IP address for host: ", this.host_name);
            new_inet_addr = null;
        }
        NodeID nodeID = this;
        synchronized (nodeID) {
            if (new_inet_addr == null) {
                this.inet_string_form = null;
                this.inet_addr = null;
                return false;
            }
            if (this.inet_addr != null && new_inet_addr.equals(this.inet_addr)) {
                return true;
            }
            this.inet_string_form = null;
            this.inet_addr = new_inet_addr;
            return true;
        }
    }

    public synchronized String toInetString() {
        if (this.inet_string_form == null) {
            InetAddress hostInetAddress = this.getHostInetAddress();
            if (hostInetAddress == null) {
                return "";
            }
            String sHostAddress = hostInetAddress.getHostAddress();
            if (sHostAddress.indexOf(58) != -1) {
                sHostAddress = "[" + sHostAddress + "]";
            }
            StringBuffer sb = new StringBuffer();
            sb.append(sHostAddress).append(":").append(this.port).append(this.path);
            this.inet_string_form = sb.toString();
        }
        return this.inet_string_form;
    }

    public String getURI() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getProtocol()).append("://").append(this.toString());
        return sb.toString();
    }

    public static void setSelf(String shost) throws Exception {
        if (selfnid != null) {
            alternateSelfnid = NodeID.getNodeID(shost);
            cat.info("alternate self NodeID set to ", alternateSelfnid);
            return;
        }
        NodeID.overrideSelf(shost);
    }

    public static void overrideSelf(String shost) throws Exception {
        selfnid = shost == null ? NodeID.getNodeID(InetAddress.getLocalHost().getHostName(), 8080, "/p2pd/servlet/dispatch") : NodeID.getNodeID(shost);
        cat.info("self NodeID set to ", selfnid);
    }

    public static NodeID getSelf() {
        if (selfnid == null) {
            try {
                NodeID.setSelf(null);
            }
            catch (Exception e) {
                cat.debug("Exception setting self node ", e);
            }
        }
        return selfnid;
    }

    @Override
    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object o) {
        return this.toString().equals(o.toString());
    }

    public boolean isSelf() {
        return this.isTheSameAs(selfnid);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isLocalToSelf() {
        return this.isSameLocalHostPort(selfnid) || alternateSelfnid != null && this.isSameLocalHostPort(alternateSelfnid);
    }

    private boolean isSameLocalHostPort(NodeID nid) {
        return nid.getPort() == this.getPort() && nid.getHostInetAddress() != null && this.getHostInetAddress() != null && (nid.getHostInetAddress().equals(this.getHostInetAddress()) || this.getHost().equalsIgnoreCase("localhost"));
    }

    public boolean isTheSameAs(NodeID other) {
        return this.host_name.equalsIgnoreCase(other.host_name) && this.port == other.port && this.path.equalsIgnoreCase(other.path);
    }

    public String getCmStatus() {
        return this.cmStatus;
    }

    public void setCmStatus(String cmStatus) {
        this.cmStatus = cmStatus;
    }

    public boolean isSameDispatcher(NodeID otherNode) {
        if (otherNode == null) {
            return false;
        }
        if (this.isSameLocalHostPort(otherNode)) {
            return this.context.equals(otherNode.getContext());
        }
        return false;
    }

    public boolean isSameDispatcher(String dispatcherName) {
        try {
            return this.isSameDispatcherNoLookup(new NodeID(dispatcherName));
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isSameDispatcherNoLookup(NodeID otherNodeID) {
        return this.host_name.equals(otherNodeID.host_name) && this.port == otherNodeID.port && this.context.equals(otherNodeID.context);
    }

    public static void setLogPriority(Priority priority) {
        cat.setPriority(priority);
    }

    public static InetAddressFactory modifyInetAddressFactoryForTesting(InetAddressFactory newFactory) {
        InetAddressFactory oldFactory = inetAddressFactory;
        inetAddressFactory = newFactory;
        return oldFactory;
    }

    public static void reset() {
        selfnid = null;
        alternateSelfnid = null;
    }

    public boolean isLocalDispatcher() {
        return this.isSameDispatcherNoLookup(selfnid);
    }
}

