/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.model;

import com.cognos.p2plb.model.NodeHospital;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeView;
import com.cognos.pogo.util.PogoLogger;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.TreeMap;

public class NodeViewPool {
    static final PogoLogger log = PogoLogger.getLogger();
    private TreeMap<NodeID, NodeView> pool = new TreeMap();
    NodeHospital the_node_hospital;

    public void setNodeHospital(NodeHospital h) {
        this.the_node_hospital = h;
    }

    public synchronized void clear() {
        this.pool.clear();
    }

    public synchronized NodeView get(NodeID key) {
        return this.pool.get(key);
    }

    public synchronized NodeView getOrCreate(NodeID key) {
        NodeView nv = this.pool.get(key);
        if (nv == null) {
            nv = new NodeView(key);
            log.debug("add node to node view pool: ", key);
            this.pool.put(key, nv);
        }
        return nv;
    }

    synchronized void put(NodeID key, NodeView node) {
        log.debug("add node to node view pool: ", key);
        this.pool.put(key, node);
    }

    public synchronized int size() {
        return this.pool.size();
    }

    public synchronized void dump(OutputStream os) {
        try {
            PrintWriter writer = new PrintWriter(os);
            for (NodeID nodeID : this.pool.keySet()) {
                writer.println(nodeID.toString());
            }
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void nodeIsSick(NodeView nv) {
        if (nv.getNodeID().isSelf() || nv.getState() == 2) {
            return;
        }
        log.debug("Node got sick: ", nv.getNodeID());
        nv.setState(2);
        this.the_node_hospital.admit(nv);
    }

    public void nodeInWrongCluster(NodeView nv) {
        if (nv.getNodeID().isSelf()) {
            return;
        }
        log.error("Node in wrong cluster, marking node as unavailable: ", nv.getNodeID());
        nv.setState(2);
        this.the_node_hospital.makeNodeUnavailable(nv);
    }

    public void nodeIsWell(NodeView nv) {
        if (nv.getNodeID().isSelf() || nv.getState() == 1) {
            return;
        }
        log.debug("Node got better: ", nv.getNodeID());
        this.the_node_hospital.discharge(nv);
        nv.setState(1);
    }
}

