/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.util;

import com.cognos.p2plb.util.Action;
import com.cognos.pogo.logging.LoggingContext;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.util.threads.SafeThread;
import java.util.LinkedList;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ActionQueue
implements Runnable {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ActionQueue.class.getName());
    static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    LinkedList<Action> actions = new LinkedList();
    Thread thread;
    boolean alive;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Action action) {
        Object object = this.actions;
        synchronized (object) {
            Action action2 = action;
            synchronized (action2) {
                if (!action.queued) {
                    action.queued = true;
                    this.actions.add(action);
                }
            }
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    public void start() {
        if (!this.alive) {
            this.thread = new SafeThread(this);
            this.thread.setDaemon(true);
            this.alive = true;
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LoggingContext loggingContext = loggingRealm.getLoggingContext();
        loggingContext.setSessionID("actionQueue");
        loggingContext.setStepID("0");
        loggingContext.setRequestID("na");
        loggingContext.setSubRequestID("na");
        cat.debug("entering ActionQueue::run()");
        while (this.alive) {
            Action action = null;
            Object object = this.actions;
            synchronized (object) {
                if (this.actions.size() > 0) {
                    action = this.actions.removeFirst();
                }
            }
            if (action != null) {
                if (cat.isDebugEnabled()) {
                    cat.debug(action.toString());
                }
                try {
                    action.run();
                }
                catch (Exception x) {
                    cat.debug("Action threw exception: ", (Throwable)x);
                }
                object = action;
                synchronized (object) {
                    action.queued = false;
                    continue;
                }
            }
            object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        cat.debug("leaving ActionQueue::run()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        cat.debug("action queue told to stop.");
        ActionQueue actionQueue = this;
        synchronized (actionQueue) {
            this.alive = false;
            this.notify();
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

