/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.util;

import com.cognos.p2pd.util.Chain;
import com.cognos.p2pd.util.ChainLink;
import com.cognos.p2plb.util.Binable;

public class LinearBins {
    protected Chain[] bins = null;
    protected int low_limit;
    protected int high_limit;
    protected int num_bins;
    protected int middling_value;
    protected double d_value_range;
    protected double d_max_bin;

    public LinearBins(int num_bins, int low_limit, int high_limit) {
        this.low_limit = low_limit;
        this.high_limit = high_limit;
        this.num_bins = num_bins;
        this.bins = new Chain[num_bins];
        this.d_value_range = high_limit - low_limit;
        this.d_max_bin = (double)(num_bins - 1) * (double)(num_bins - 1);
        this.middling_value = low_limit + (high_limit - low_limit) / 4;
    }

    public int getLowLimit() {
        return this.low_limit;
    }

    public int getHighLimit() {
        return this.high_limit;
    }

    public int getMiddlingValue() {
        return this.middling_value;
    }

    public synchronized int bin(Binable b) {
        int ibin = this.calcBinIndex(b.getValue());
        b.getLink().unlink();
        if (null == this.bins[ibin]) {
            this.bins[ibin] = new Chain();
        }
        this.bins[ibin].addEnd(b.getLink());
        b.setBinNumber(ibin);
        return ibin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rebin(Binable b) {
        int ibin = this.calcBinIndex(b.getValue());
        if (ibin == b.getBinNumber()) {
            return ibin;
        }
        LinearBins linearBins = this;
        synchronized (linearBins) {
            b.getLink().unlink();
            if (null == this.bins[ibin]) {
                this.bins[ibin] = new Chain();
            }
            this.bins[ibin].addEnd(b.getLink());
            b.setBinNumber(ibin);
        }
        return ibin;
    }

    public synchronized void unbin(Binable b) {
        b.getLink().unlink();
        b.setBinNumber(-1);
    }

    public synchronized Binable getBest() {
        for (int i = 0; i < this.num_bins; ++i) {
            Chain ch = this.bins[i];
            if (ch == null || ch.size() <= 0) continue;
            ChainLink head = ch.popStart();
            ch.addEnd(head);
            return (Binable)head.getObject();
        }
        return null;
    }

    public int calcBinIndex(int value) {
        if (value < this.low_limit) {
            return 0;
        }
        if (value >= this.high_limit) {
            return this.num_bins - 1;
        }
        return (int)Math.sqrt(((double)value - (double)this.low_limit) / this.d_value_range * this.d_max_bin);
    }
}

