/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.impl;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.AsyncState;
import com.cognos.pogo.async.impl.AsyncConversationState;
import com.cognos.pogo.async.impl.AsyncRequestThread;
import com.cognos.pogo.async.impl.AsyncStateException;
import com.cognos.pogo.capacity.ServiceCapacityConfiguration;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MCUtils;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.performance.events.ServiceEvent;
import com.cognos.pogo.reportservice.ConnectionAssignmentInterlock;
import com.cognos.pogo.util.PogoLogger;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.lang.StringUtils;

public class AsyncContextImpl
implements AsyncContext {
    private static final PogoLogger log = PogoLogger.getLogger();
    private String conversationID;
    private Object contextObject;
    private AsyncService service;
    private MessageContext messageContext;
    private AsyncRequestThread requestThread;
    private AsyncConversationState asyncState = new AsyncConversationState();
    private boolean[] doneFlag = new boolean[1];
    private int abandonedTickCount;
    private Handler onCompletionHandler;
    private boolean waitIsPending;
    private ServiceCapacityConfiguration serviceCapacityConfiguration;
    private Date queueTime;
    private ConnectionAssignmentInterlock connectionAssignmentInterlock = new ConnectionAssignmentInterlock();

    @Override
    public String getConversationID() {
        return this.conversationID;
    }

    @Override
    public void setContextObj(Object o) {
        this.contextObject = o;
    }

    @Override
    public Object getContextObj() {
        return this.contextObject;
    }

    @Override
    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    @Override
    public AsyncState getState() {
        return this.asyncState.getAsyncState();
    }

    public void resetState() {
        this.asyncState.setNew();
        this.doneFlag[0] = false;
    }

    AsyncContextImpl(String conversationID, AsyncService service, MessageContext originalRequest) {
        this.conversationID = conversationID;
        this.service = service;
        this.messageContext = originalRequest;
        this.doneFlag[0] = false;
        this.abandonedTickCount = 0;
    }

    void setConversationID(String conversationID) {
        this.conversationID = conversationID;
    }

    void setQueued() {
        this.queueTime = new Date();
        try {
            this.asyncState.setQueued();
        }
        catch (AsyncStateException e) {
            log.warn("queued an async context that is not ready to execute", e);
        }
    }

    public void runRequest(AsyncRequestThread requestThread) {
        this.setRequestThread(requestThread);
        if (this.asyncState.getAsyncState() == AsyncState.CANCELLED || this.asyncState.getAsyncState() == AsyncState.ABANDONED) {
            log.debug("request was cancelled before we could execute it.");
            this.getMessageContext().setFault(new Fault("REQUEST_CANCELLED"));
            this.announceDone();
        }
        try {
            this.asyncState.setExecuting();
            this.invokeService();
            log.debug("returned from service.invoke()");
            this.invokeOnCompletionHandler();
            if (this.getState() == AsyncState.CANCELLED || this.getState() == AsyncState.ABANDONED) {
                this.discardCancelledRequest();
            }
        }
        catch (AsyncStateException e) {
            log.error("unable to set state of async request to executing", e);
            this.getMessageContext().setFault(new Fault("INVALID_ASYNC_STATE_TRANSITION", e));
        }
        catch (Throwable t) {
            log.error("Async service threw an unexpected exception or throwable", t);
            this.getMessageContext().setFault(new Fault("ASYNC_SERVICE_THREW"));
        }
        try {
            if (this.getMessageContext().isFaulted()) {
                log.debug("async execution produced a fault.");
                this.asyncState.setFaulted();
            } else {
                this.asyncState.setOutputReady();
                this.setWaitPending(true);
            }
        }
        catch (AsyncStateException e) {
            log.debug("Unable to set state of async request to execution complete.  The request may have been cancelled, or completed already.", e);
        }
        this.announceDone();
        this.setRequestThread(null);
    }

    private void invokeService() {
        ServiceEvent perfEvent = new ServiceEvent(this.getServiceName(), this.getMessageContext());
        try {
            this.service.invoke(this);
        }
        finally {
            perfEvent.completed();
        }
    }

    private String getServiceName() {
        String serviceName = this.service.toString();
        return this.isUndefined(serviceName) ? this.service.getClass().getSimpleName() : serviceName;
    }

    private boolean isUndefined(String serviceName) {
        return StringUtils.contains((String)serviceName, (String)"@");
    }

    private void discardCancelledRequest() {
        MessageContext mc = this.getMessageContext();
        log.debug("discardCancelledRequest() enter");
        try {
            Iterator itAttachments = (Iterator)mc.getProperty("response.attachments");
            if (itAttachments != null && itAttachments.hasNext()) {
                byte[] buf = new byte[8192];
                while (itAttachments.hasNext()) {
                    log.debug("reading an attachment prepared by the service");
                    InputStream pis = (InputStream)itAttachments.next();
                    new InternetHeaders(pis);
                    while (pis.read(buf) > 0) {
                    }
                }
            }
        }
        catch (Exception x) {
            log.debug("exception while attempting to read and discard response to cancelled request", x);
        }
        mc.setProperty("response.attachments", null);
        List<Cleanable> cleanables = MCUtils.getCleanables(mc);
        if (cleanables != null) {
            int cleanablesSize = cleanables.size();
            log.debug("discardCancelledRequest() : There are ", cleanablesSize, " items to be cleaned");
            for (int i = 0; i < cleanablesSize; ++i) {
                Cleanable c = cleanables.get(i);
                log.debug("calling clean on ", c.getClass().getName(), ", ", c);
                c.clean(mc);
            }
            cleanables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void announceDone() {
        boolean[] blArray = this.doneFlag;
        synchronized (this.doneFlag) {
            log.debug("announce async execution is complete");
            this.doneFlag[0] = true;
            this.doneFlag.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForDone() {
        boolean[] blArray = this.doneFlag;
        synchronized (this.doneFlag) {
            if (this.doneFlag[0]) {
                log.debug("waitForDone() - async execution is complete");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            int threshold = this.service.getAsyncThreshold();
            if (threshold < 0) {
                log.error("invalid async threshold: ", threshold, ", using 60s.");
                threshold = 60;
            }
            try {
                log.debug("waitForDone() - will wait for async execution to complete");
                this.doneFlag.wait(threshold * 1000);
                log.debug("waitForDone() - finished waiting");
            }
            catch (InterruptedException e) {
                log.debug("waitForDone() - wait interrupted");
            }
            log.debug("doneFlag = ", this.doneFlag[0]);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.doneFlag[0];
        }
    }

    @Override
    public void outputReady() {
        try {
            this.asyncState.setOutputReady();
        }
        catch (AsyncStateException e) {
            log.error("Unable to set state of async request to execution complete.  The request may have been cancelled.", e);
        }
        this.announceDone();
        this.setWaitPending(true);
    }

    public String toString() {
        return "AsyncContext-" + this.conversationID + ", runState=" + this.asyncState;
    }

    int bumpTickCount() {
        return ++this.abandonedTickCount;
    }

    int getTickCount() {
        return this.abandonedTickCount;
    }

    private void resetTickCount() {
        this.abandonedTickCount = 0;
    }

    void waitReceived(MessageContext mc) {
        this.setWaitPending(false);
        this.service.waitReceived(mc, this);
    }

    void abandonRequest() {
        this.asyncState.setAbandoned();
        this.service.abandon(this);
        this.discardCancelledRequest();
        this.interruptRequestThread();
    }

    void cancelRequest(MessageContext mc) {
        this.asyncState.setCancelled();
        this.service.cancel(mc, this);
        this.interruptRequestThread();
        this.setWaitPending(false);
    }

    private void setRequestThread(AsyncRequestThread requestThread) {
        this.requestThread = requestThread;
    }

    private void interruptRequestThread() {
        if (this.requestThread != null) {
            log.debug("interrupting async request thread: ", this.requestThread.getName());
            this.requestThread.interrupt();
        }
    }

    void release() {
        this.asyncState.setCancelled();
        this.setWaitPending(false);
        this.interruptRequestThread();
    }

    void getOutput(MessageContext mc) {
        this.setWaitPending(false);
        try {
            this.asyncState.setComplete();
            this.service.getOutput(mc, this);
        }
        catch (AsyncStateException e) {
            log.error("getOutput() - cannot get output, invalid async state transition", e);
            mc.setFault(new Fault("INVALID_ASYNC_STATE_TRANSITION_CANT_GETOUTPUT", e));
        }
    }

    void working(MessageContext mc) {
        this.service.working(mc, this);
        BIBusEnvelope responseEnv = (BIBusEnvelope)mc.getProperty(mc.getResponseName() + ".envelope");
        this.prepareTracking(responseEnv);
        responseEnv.setConversationContextStatus("working");
        this.setWaitPending(true);
    }

    void stillWorking(MessageContext mc) {
        this.service.stillWorking(mc, this);
        BIBusEnvelope responseEnv = (BIBusEnvelope)mc.getProperty(mc.getResponseName() + ".envelope");
        responseEnv.setConversationContextStatus("stillWorking");
        this.setWaitPending(true);
    }

    void responseReady(MessageContext mc) {
        this.service.responseReady(mc, this);
        BIBusEnvelope responseEnv = (BIBusEnvelope)mc.getProperty(mc.getResponseName() + ".envelope");
        if (responseEnv == null) {
            log.debug("hmm, in responseReady and responseEnv is null.  This probably means that the reply is a fault.");
        } else {
            String status = responseEnv.getConversationContextStatus();
            log.debug("in responseReady(), service generated response status: ", status);
            try {
                if (!"complete".equals(status)) {
                    if ("conversationComplete".equals(status)) {
                        this.asyncState.setComplete();
                    } else if ("stillWorking".equals(status)) {
                        this.setWaitPending(true);
                        this.asyncState.setOutputReady();
                    } else {
                        log.error("unexpected async conversation response status: ", status);
                    }
                }
            }
            catch (AsyncStateException e) {
                log.error("illegal async state change.", e);
            }
        }
    }

    private void prepareTracking(BIBusEnvelope responseEnv) {
        responseEnv.setConversationContextID(this.getConversationID());
        responseEnv.setConversationContextNodeID(NodeID.getSelf().getGuid());
        responseEnv.setConversationContextProcessID(0);
    }

    void setCompletionHandler(Handler onCompletionHandler) {
        this.onCompletionHandler = onCompletionHandler;
    }

    void invokeOnCompletionHandler() throws PogoException {
        if (this.onCompletionHandler == null) {
            log.debug("no onCompletionHandler has been set.");
        } else {
            log.debug("invoking onCompletionHandler");
            this.onCompletionHandler.invoke(this.getMessageContext());
        }
    }

    void replyNow(MessageContext mc) {
        this.service.replyNow(mc, this);
    }

    synchronized void setWaitPending(boolean b) {
        if (b) {
            this.resetTickCount();
        }
        this.waitIsPending = b;
    }

    synchronized boolean isWaitPending() {
        return this.waitIsPending;
    }

    public void setServiceCapacityConfiguration(ServiceCapacityConfiguration configuration) {
        this.serviceCapacityConfiguration = configuration;
    }

    public ServiceCapacityConfiguration getServiceCapacityConfiguration() {
        return this.serviceCapacityConfiguration;
    }

    public long getQueuedTime() {
        if (this.queueTime != null) {
            return System.currentTimeMillis() - this.queueTime.getTime();
        }
        return 0L;
    }

    public void setMessageContext(MessageContext asyncMC) {
        this.messageContext = asyncMC;
    }

    public void setService(AsyncService service) {
        this.service = service;
    }

    @Override
    public ConnectionAssignmentInterlock getConnectionAssignmentInterlock() {
        return this.connectionAssignmentInterlock;
    }

    AsyncRequestThread getRequestThread() {
        return this.requestThread;
    }
}

