/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.impl;

import com.cognos.pogo.async.impl.AsyncRequestThread;
import java.util.ArrayList;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class AsyncThreadPool {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(AsyncThreadPool.class.getName());
    private ArrayList<AsyncRequestThread> idleThreads;
    private int busyThreadCount;
    private int maxThreads;
    private String baseThreadName;
    private static int threadCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextThreadName() {
        AsyncThreadPool asyncThreadPool = this;
        synchronized (asyncThreadPool) {
            return this.baseThreadName + threadCount++;
        }
    }

    AsyncThreadPool(String baseThreadName, int maxThreads) {
        this.baseThreadName = baseThreadName;
        this.idleThreads = new ArrayList(maxThreads);
        this.busyThreadCount = 0;
        this.maxThreads = maxThreads;
    }

    synchronized AsyncRequestThread borrowThread() {
        if (this.busyThreadCount >= this.maxThreads) {
            logger.debug("borrowThread() - none available, return null");
            return null;
        }
        ++this.busyThreadCount;
        if (this.idleThreads.isEmpty()) {
            AsyncRequestThread t = new AsyncRequestThread(this.getNextThreadName());
            t.setDaemon(true);
            t.start();
            logger.debug("borrowThread() - create and return new async thread: " + t);
            return t;
        }
        AsyncRequestThread t = this.idleThreads.remove(this.idleThreads.size() - 1);
        logger.debug("borrowThread() - return idle thread: " + t);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnThread(AsyncRequestThread t) {
        AsyncThreadPool asyncThreadPool = this;
        synchronized (asyncThreadPool) {
            --this.busyThreadCount;
            if (this.busyThreadCount + this.idleThreads.size() < this.maxThreads) {
                this.idleThreads.add(this.idleThreads.size(), t);
                logger.debug("returnThread() - thread return to the idle list: " + t);
                t = null;
            }
        }
        if (t != null) {
            logger.debug("returnThread() - terminate unneeded thread: " + t);
            t.terminate();
        }
    }

    synchronized boolean isThreadValid(AsyncRequestThread t) {
        boolean valid;
        boolean bl = valid = this.busyThreadCount <= this.maxThreads;
        if (logger.isDebugEnabled()) {
            logger.debug("isThreadValid() - returning " + valid + ", busyThreadCount=" + this.busyThreadCount + ", maxThreads=" + this.maxThreads);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxThreads(int maxThreads) {
        logger.debug("setMaxThreads to: " + maxThreads);
        AsyncRequestThread[] redundants = null;
        int excess = 0;
        AsyncThreadPool asyncThreadPool = this;
        synchronized (asyncThreadPool) {
            this.maxThreads = maxThreads;
            if (this.busyThreadCount + this.idleThreads.size() > maxThreads) {
                excess = this.busyThreadCount + this.idleThreads.size() - maxThreads;
                if ((excess = Math.min(excess, this.idleThreads.size())) > 0) {
                    redundants = new AsyncRequestThread[excess];
                    for (int i = 0; i < excess; ++i) {
                        redundants[i] = this.idleThreads.remove(this.idleThreads.size() - 1);
                    }
                }
            }
        }
        if (redundants != null) {
            logger.debug("terminating " + excess + " excess threads.");
            for (int i = 0; i < excess; ++i) {
                redundants[i].terminate();
            }
        }
    }

    public int getBusyThreadCount() {
        return this.busyThreadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleThreadCount() {
        ArrayList<AsyncRequestThread> arrayList = this.idleThreads;
        synchronized (arrayList) {
            return this.idleThreads.size();
        }
    }

    int getMaxThreads() {
        return this.maxThreads;
    }
}

