/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.service;

import com.cognos.pogo.async.service.AsyncRequestPassportIdManagerTask;
import com.cognos.pogo.util.timer.PogoTimer;
import java.io.Reader;
import java.io.StringReader;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class AsyncRequestPassportIdManager {
    private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(AsyncRequestPassportIdManager.class.getName());
    private long passportRefreshRate = 2700000L;
    private long passportRefreshDelay = this.passportRefreshRate / 2L;
    private Timer passportIdExpiryResetTimer = null;

    public void setPassportRefreshRate(int passportRefreshRate) {
        this.passportRefreshRate = passportRefreshRate;
        this.passportRefreshDelay = passportRefreshRate / 2;
    }

    public void setPassportIdExpiryRefreshRate(String aaaConfig) {
        if (aaaConfig.length() > 0) {
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read((Reader)new StringReader(aaaConfig));
                Element value = (Element)document.getRootElement().selectSingleNode("./*[local-name()='parameter' and @*[local-name()='name']='inactivityTimeout']/*[local-name()='value']");
                if (value != null) {
                    int intValue = Integer.parseInt(value.getText());
                    this.setPassportRefreshRate(intValue * 3000 / 4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void start() {
        this.passportIdExpiryResetTimer = PogoTimer.createNativeTimer("AsyncRequestPassportIdManagerTimer");
    }

    public synchronized void stop() {
        if (this.passportIdExpiryResetTimer != null) {
            this.passportIdExpiryResetTimer.cancel();
            this.passportIdExpiryResetTimer = null;
        }
    }

    public synchronized AsyncRequestPassportIdManagerTask addPassportIdManagerTask(String passportId) {
        AsyncRequestPassportIdManagerTask passportIdManagerTask = null;
        if (this.passportIdExpiryResetTimer != null) {
            logger.debug("Activating passport id expiry reset task");
            passportIdManagerTask = new AsyncRequestPassportIdManagerTask();
            passportIdManagerTask.setPassportId(passportId);
            this.passportIdExpiryResetTimer.schedule((TimerTask)passportIdManagerTask, this.passportRefreshDelay, this.passportRefreshRate);
        }
        return passportIdManagerTask;
    }

    public void removePassportIdManagerTask(AsyncRequestPassportIdManagerTask passportIdManagerTask) {
        if (passportIdManagerTask != null) {
            logger.debug("Deactivating passport id expiry reset task");
            passportIdManagerTask.setPassportId("");
            passportIdManagerTask.cancel();
        }
    }
}

