/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.service;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerPassportValidateCommand;
import com.cognos.pogo.util.threads.SafeTimerTask;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class AsyncRequestPassportIdManagerTask
extends SafeTimerTask {
    private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(AsyncRequestPassportIdManagerTask.class.getName());
    private String passportId = new String();

    public AsyncRequestPassportIdManagerTask() {
        logger.debug("Adding passport id expiry task to list");
    }

    @Override
    public void safeRun() {
        try {
            String passportId = this.getPassportId();
            if (passportId.length() > 0) {
                logger.debug("Refreshing passport id" + passportId);
                ContentManagerPassportValidateCommand validatePassport = new ContentManagerPassportValidateCommand();
                validatePassport.setPassportId(passportId);
                validatePassport.execute();
                this.setPassportId(validatePassport.getPassportId());
            } else {
                logger.debug("Removing passport id expiry task from list");
                this.cancel();
            }
        }
        catch (CommandExecutionException e) {
            logger.debug("Error executing passport id expiry task - removing task from list");
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPassportId() {
        AsyncRequestPassportIdManagerTask asyncRequestPassportIdManagerTask = this;
        synchronized (asyncRequestPassportIdManagerTask) {
            return this.passportId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassportId(String passportId) {
        AsyncRequestPassportIdManagerTask asyncRequestPassportIdManagerTask = this;
        synchronized (asyncRequestPassportIdManagerTask) {
            this.passportId = passportId;
        }
    }
}

