/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.auth;

import com.cognos.pogo.auth.CAMSystemRecoverableHandler;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.RequestModifier;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.util.PogoLogger;
import javax.mail.internet.InternetHeaders;
import javax.servlet.http.HttpServletRequest;

public class NewAuthHandler
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    static final String CAMNAMESPACE_FORM_NAME = "CAMNamespace";
    protected RequestModifier reqModifier;
    protected Handler auth_handler;
    private boolean checkFault = true;

    public NewAuthHandler() {
        super(log.getNativeLogger());
    }

    public Handler getAuthHandler() {
        return this.auth_handler;
    }

    private boolean checkForCAMSystemRecoverableFault(MessageContext mc, ResponseWrapper wrapper) {
        BIBusEnvelope responseEnvelope = wrapper.getResponse();
        if (this.checkFault) {
            responseEnvelope = (BIBusEnvelope)mc.getProperty("response.envelope");
            wrapper.setResponse(responseEnvelope);
            if (this.hasNoFault(responseEnvelope)) {
                return false;
            }
            return NewAuthHandler.isSystemRecoverable(responseEnvelope);
        }
        if (!mc.isFaulted()) {
            log.debug("mc is not falted");
            return false;
        }
        Fault fault = mc.getFault();
        if (!fault.isCreatedFromSOAPEnvelope()) {
            this.logFaultNotFromSoapEnvelope(fault);
            return false;
        }
        responseEnvelope = (BIBusEnvelope)fault.generateEnvelope();
        wrapper.setResponse(responseEnvelope);
        return NewAuthHandler.isSystemRecoverable(responseEnvelope);
    }

    private void logFaultNotFromSoapEnvelope(Fault fault) {
        try {
            log.debug("Fault is not from soap envelope: ", fault.generateEnvelope());
        }
        catch (Exception e) {
            log.debug("Fault is not from soap envelope: ", e);
        }
    }

    private boolean hasNoFault(BIBusEnvelope responseEnvelope) {
        return responseEnvelope == null || !responseEnvelope.getBodyFault().isPresent();
    }

    static boolean isSystemRecoverable(Envelope envelope) {
        String errorCodeString = envelope.getBiBusHeader().getCam().getException().getErrorCodeString();
        boolean isSystemRecoverable = "camAuthSystemRecoverable".equalsIgnoreCase(errorCodeString);
        log.debug("isSystemRecoverable: ", isSystemRecoverable);
        return isSystemRecoverable;
    }

    @Override
    public void configure(Configuration configuration) {
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        InternetHeaders headers = (InternetHeaders)mc.getProperty("request.headers");
        String fromGateway = headers.getHeader("Cognos-Gateway", null);
        if (fromGateway != null) {
            this.auth_handler.invoke(mc);
            return;
        }
        Boolean setCookieHere = (Boolean)mc.getProperty("setCookieInThisDispatcher");
        if (!setCookieHere.booleanValue()) {
            this.auth_handler.invoke(mc);
            return;
        }
        BIBusEnvelope request_env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String camAction = request_env.getCAMAction();
        log.debug("The original CAM action is: ", camAction);
        String camNamespace = request_env.getFormValue(CAMNAMESPACE_FORM_NAME);
        log.debug("The original CAMNamespace is: ", camNamespace);
        ResponseWrapper wrapper = new ResponseWrapper();
        while (true) {
            this.auth_handler.invoke(mc);
            if (!this.checkForCAMSystemRecoverableFault(mc, wrapper)) break;
            HttpServletRequest hsr = (HttpServletRequest)mc.getProperty("http_servlet_request");
            this.reqModifier.alterRequest(hsr, wrapper.getResponse(), request_env);
            mc.setFault(null);
            request_env = (BIBusEnvelope)mc.getProperty("request.envelope");
            if (camAction != null) {
                log.debug("Resetting the CAM action to: ", camAction);
                request_env.setCAMaction(camAction);
            }
            if (camNamespace == null || request_env.getFormValue(CAMNAMESPACE_FORM_NAME) != null) continue;
            log.debug("Resetting the CAMNamespace to: ", camNamespace);
            request_env.setFormField(CAMNAMESPACE_FORM_NAME, camNamespace);
        }
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.composeWithModifier(engine, new CAMSystemRecoverableHandler());
    }

    void composeWithModifier(PogoEngine engine, CAMSystemRecoverableHandler reqModifier) throws PogoException {
        this.setRequestModifier(reqModifier);
        String name = this.getConfig().attributeValue("wrapped_auth_check");
        if (name == null || "".equals(name)) {
            name = "pogo.original_auth_check";
            this.checkFault = false;
        }
        this.auth_handler = engine.getHandlerPool().find(name);
        if (this.auth_handler == null) {
            log.error("cannot find auth_handler \"" + name + "\"");
            throw new PogoException("cannot find auth_handler");
        }
        String checkFaultStr = this.getOptionalAttribute("check_fault");
        if (checkFaultStr != null && checkFaultStr.equalsIgnoreCase("false")) {
            this.checkFault = false;
        }
        this.auth_handler.compose(engine);
    }

    private void setRequestModifier(CAMSystemRecoverableHandler reqModifier) {
        this.reqModifier = reqModifier;
        this.reqModifier.init();
    }

    public class ResponseWrapper {
        private BIBusEnvelope responseEnvelope;

        public void setResponse(BIBusEnvelope responseEnvelope) {
            this.responseEnvelope = responseEnvelope;
        }

        public BIBusEnvelope getResponse() {
            return this.responseEnvelope;
        }
    }
}

