/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.bibus;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.bibus.BufferedOutputStreamSpy;
import com.cognos.pogo.http.MessageOutputter;
import com.cognos.pogo.http.inprocess.LocalServerConnection;
import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.pogo.pdk.SOAPXMLSource;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.Check;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;

public class SOAPMessageOutputter
implements MessageOutputter {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final String CONTENT_TYPE = "Content-Type: ";
    private static final String CONTENT_LENGTH = "Content-Length: ";
    private static final String UTF8 = "utf-8";
    private static final String TEXT_XML = "text/xml";
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml; charset=utf-8";
    private static final String MULTI_PART_RELATED_TEXT_XML = "multipart/related; type=\"text/xml\"";
    private static final String MULTI_PART_CONTENT_TYPE = "multipart/related; type=\"text/xml\"; boundary=\"";
    private static final String MULTI_PART_CONTENT_TYPE_P1 = "multipart/related; type=\"text/xml\"; start=\"";
    private static final String MULTI_PART_CONTENT_TYPE_P2 = "; boundary=\"";
    private static final String MULTI_PART_BYTERANGES_CONTENT_TYPE = "multipart/byteranges; boundary=";
    private static final String MULTI_PART_BYTERANGES_CONTENT_TYPE_P1 = "multipart/byteranges; start=";
    private static final String MULTI_PART_BYTERANGES_CONTENT_TYPE_P2 = "; boundary=";
    private static final byte[] baCONTENT_TYPE_TEXTXML = "Content-Type: text/xml; charset=utf-8\r\n".getBytes();
    private static final byte[] baCONTENTID_SP = "Content-ID: ".getBytes();
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final int BUFFER_SIZE = 8192;
    private SOAPXMLSource anEnvelope;
    private Iterator<InputStream> soapAttachments;
    private BufferedOutputStreamSpy outStream;
    private String mimeBoundary;
    private String mimeStartPartContentID;
    private Outputter myOutputter;
    private boolean doTrustedRequest;
    private String serviceID;

    public SOAPMessageOutputter(SOAPXMLSource envelope, Iterator<InputStream> attachments, OutputStream output) {
        this(envelope == null, envelope, attachments, output);
    }

    public SOAPMessageOutputter(boolean isMultiByteRanges, SOAPXMLSource envelope, Iterator<InputStream> attachments, OutputStream output) {
        this.anEnvelope = envelope;
        this.soapAttachments = attachments;
        boolean canResend = this.rewindAttachment();
        this.setOutputStream(output);
        this.myOutputter = isMultiByteRanges && this.soapAttachments != null && this.soapAttachments.hasNext() ? new MultipartByterangeOutputter() : (this.soapAttachments != null && this.soapAttachments.hasNext() ? new MultipartOutputter() : new SimpleOutputter());
        this.setCanResend(canResend);
    }

    public void setOutputStream(OutputStream output) {
        this.outStream = output != null ? new BufferedOutputStreamSpy(output, 8192) : null;
    }

    public void write() throws IOException {
        Check.notNull(this.outStream);
        try {
            this.myOutputter.write();
            this.outStream.flush();
        }
        catch (IOException ex) {
            if (this.soapAttachments != null) {
                if (this.soapAttachments instanceof MIMEPartParser) {
                    ((MIMEPartParser)this.soapAttachments).close();
                    return;
                }
                while (this.soapAttachments.hasNext()) {
                    InputStream aStream = this.soapAttachments.next();
                    try {
                        aStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            throw ex;
        }
    }

    public String getContentType() {
        return this.myOutputter.getContentType();
    }

    public void setMimeBoundary(String boundary) {
        Check.notNull(boundary);
        this.mimeBoundary = boundary;
    }

    public void setMimeStartPartContentID(String cid) {
        this.mimeStartPartContentID = cid;
    }

    void setDoTrustedRequest(boolean trusted, String serviceID) {
        this.doTrustedRequest = trusted;
        this.serviceID = serviceID;
    }

    public boolean canResend() {
        return this.myOutputter.canResend();
    }

    private String getMimeBoundary() {
        if (this.mimeBoundary == null) {
            this.mimeBoundary = StringUtils.getUniqueValue();
        }
        return this.mimeBoundary;
    }

    public SOAPXMLSource getEnvelope() {
        return this.anEnvelope;
    }

    public void setLocalServerConnection(LocalServerConnection localServerConnection) {
        this.myOutputter.setLocalServerConnection(localServerConnection);
    }

    public Outputter getMyOutputter() {
        return this.myOutputter;
    }

    public void setCanResend(boolean canResend) {
        this.myOutputter.setCanResend(canResend);
    }

    public boolean rewindAttachment() {
        boolean attachWasReWound = false;
        if (this.soapAttachments != null && this.soapAttachments instanceof MIMEPartParser && !this.soapAttachments.hasNext() && ((MIMEPartParser)this.soapAttachments).rewindAttachment()) {
            attachWasReWound = true;
            cat.warn("Successfully rewound a MIMEPartParser attachment");
        }
        return attachWasReWound;
    }

    public class MultipartByterangeOutputter
    extends MultipartOutputter {
        @Override
        protected String getContentType() {
            if (SOAPMessageOutputter.this.mimeStartPartContentID == null) {
                return SOAPMessageOutputter.MULTI_PART_BYTERANGES_CONTENT_TYPE + SOAPMessageOutputter.this.getMimeBoundary();
            }
            return SOAPMessageOutputter.MULTI_PART_BYTERANGES_CONTENT_TYPE_P1 + SOAPMessageOutputter.this.mimeStartPartContentID + SOAPMessageOutputter.MULTI_PART_BYTERANGES_CONTENT_TYPE_P2 + SOAPMessageOutputter.this.getMimeBoundary();
        }

        @Override
        protected void writeAttachments(byte[] startMimeBoundary) throws IOException {
            byte[] buf = new byte[8192];
            int count = 0;
            while (SOAPMessageOutputter.this.soapAttachments.hasNext()) {
                int totalBytesRead = 0;
                cat.debug("Writing attachment number ", ++count);
                InputStream is = (InputStream)SOAPMessageOutputter.this.soapAttachments.next();
                try {
                    SOAPMessageOutputter.this.outStream.write(startMimeBoundary);
                    InternetHeaders headers = new InternetHeaders(is);
                    this.removeAcrobatReaderBarfHeaders(headers);
                    Enumeration headenum = headers.getAllHeaderLines();
                    while (headenum.hasMoreElements()) {
                        String head = (String)headenum.nextElement();
                        SOAPMessageOutputter.this.outStream.write(head.getBytes());
                        SOAPMessageOutputter.this.outStream.write("\r\n".getBytes());
                    }
                    SOAPMessageOutputter.this.outStream.write("\r\n".getBytes());
                }
                catch (MessagingException e) {
                    cat.error("Trouble removing headers from multipart byterange part");
                }
                catch (IOException ex) {
                    is.close();
                    throw ex;
                }
                try {
                    int iread = is.read(buf, 0, 8192);
                    while (iread > 0) {
                        SOAPMessageOutputter.this.outStream.write(buf, 0, iread);
                        totalBytesRead += iread;
                        iread = is.read(buf, 0, 8192);
                    }
                }
                catch (IOException ex) {
                    is.close();
                    throw ex;
                }
                cat.debug("Wrote attachment ", count, " of size: ", totalBytesRead);
            }
        }

        private void removeAcrobatReaderBarfHeaders(InternetHeaders headers) {
            headers.removeHeader("Content-Length");
            headers.removeHeader("Content-Transfer-Encoding");
            headers.removeHeader("Content-ID");
            headers.removeHeader("Accept-Ranges");
        }
    }

    public class MultipartOutputter
    extends Outputter {
        private static final String MAX_EMPTY_ATTACHMENTS_PROPERTY = "SOAPMessageOutputter.maxEmptyAttachmentsAllowed";
        private static final int MAX_EMPTY_ATTACHMENTS_DEFAULT = 10;

        private void writeSOAPPart(byte[] startMimeBoundary) throws IOException, UnsupportedEncodingException {
            SOAPMessageOutputter.this.outStream.write(startMimeBoundary);
            SOAPMessageOutputter.this.outStream.write(baCONTENT_TYPE_TEXTXML);
            if (SOAPMessageOutputter.this.mimeStartPartContentID != null) {
                SOAPMessageOutputter.this.outStream.write(baCONTENTID_SP);
                SOAPMessageOutputter.this.outStream.write(SOAPMessageOutputter.this.mimeStartPartContentID.getBytes(SOAPMessageOutputter.UTF8));
                SOAPMessageOutputter.this.outStream.write(CRLF);
            }
            ByteArrayOutputStream docOut = new ByteArrayOutputStream();
            SOAPMessageOutputter.this.anEnvelope.writeAsXML(docOut);
            byte[] docBuf = docOut.toByteArray();
            if (SOAPMessageOutputter.this.doTrustedRequest) {
                docBuf = this.signTrustedRequest(docBuf);
            }
            String contentLengthHeader = SOAPMessageOutputter.CONTENT_LENGTH + Integer.toString(docBuf.length);
            SOAPMessageOutputter.this.outStream.write(contentLengthHeader.getBytes(SOAPMessageOutputter.UTF8));
            SOAPMessageOutputter.this.outStream.write(CRLF);
            SOAPMessageOutputter.this.outStream.write(CRLF);
            SOAPMessageOutputter.this.outStream.write(docBuf);
        }

        protected void writeAttachments(byte[] startMimeBoundary) throws IOException {
            int maxEmptyAttachmentsAllowed = this.getMaxEmptyAttachmentsAllowed();
            byte[] buf = new byte[8192];
            int count = 0;
            while (SOAPMessageOutputter.this.soapAttachments.hasNext()) {
                int totalBytesRead = 0;
                cat.debug("Writing attachment number ", ++count);
                InputStream is = (InputStream)SOAPMessageOutputter.this.soapAttachments.next();
                try {
                    SOAPMessageOutputter.this.outStream.write(startMimeBoundary);
                    int iread = is.read(buf, 0, 8192);
                    while (iread > 0) {
                        SOAPMessageOutputter.this.outStream.write(buf, 0, iread);
                        totalBytesRead += iread;
                        iread = is.read(buf, 0, 8192);
                    }
                }
                catch (IOException ex) {
                    is.close();
                    throw ex;
                }
                cat.debug("Wrote attachment ", count, " of size: ", totalBytesRead);
                if (!this.isEmptyAttachment(totalBytesRead) || --maxEmptyAttachmentsAllowed > 0) continue;
                cat.error("Too many empty attachments detected. Stopping the attachment stream.");
                return;
            }
        }

        private boolean isEmptyAttachment(int totalBytesRead) {
            return totalBytesRead == 0;
        }

        private int getMaxEmptyAttachmentsAllowed() {
            String propertyValue = PropertyInserter.getProperty(MAX_EMPTY_ATTACHMENTS_PROPERTY, String.valueOf(10));
            try {
                return Integer.valueOf(propertyValue);
            }
            catch (NumberFormatException e) {
                cat.warn("Invalid value for property SOAPMessageOutputter.maxEmptyAttachmentsAllowed: " + propertyValue, e);
                return 10;
            }
        }

        @Override
        protected void write() throws IOException {
            try {
                byte[] startMimeBoundary = ("\r\n--" + SOAPMessageOutputter.this.getMimeBoundary() + "\r\n").getBytes(SOAPMessageOutputter.UTF8);
                byte[] endMimeBoundary = ("\r\n--" + SOAPMessageOutputter.this.getMimeBoundary() + "--\r\n").getBytes(SOAPMessageOutputter.UTF8);
                if (SOAPMessageOutputter.this.anEnvelope != null) {
                    this.writeSOAPPart(startMimeBoundary);
                }
                this.writeOrPostponeAttachments(startMimeBoundary, endMimeBoundary);
                SOAPMessageOutputter.this.outStream.dumpToLog(this);
            }
            catch (UnsupportedEncodingException ex) {
                throw new IOException(ex.getLocalizedMessage());
            }
        }

        private void writeOrPostponeAttachments(byte[] startMimeBoundary, byte[] endMimeBoundary) throws IOException {
            LocalServerConnection localServerConnection = this.getLocalServerConnection();
            if (localServerConnection != null) {
                localServerConnection.postponeStreaming(SOAPMessageOutputter.this.soapAttachments, startMimeBoundary, endMimeBoundary);
            } else {
                this.writeAttachments(startMimeBoundary, endMimeBoundary);
            }
        }

        private void writeAttachments(byte[] startMimeBoundary, byte[] endMimeBoundary) throws IOException {
            this.writeAttachments(startMimeBoundary);
            SOAPMessageOutputter.this.outStream.write(endMimeBoundary);
        }

        @Override
        protected String getContentType() {
            if (SOAPMessageOutputter.this.mimeStartPartContentID == null) {
                return SOAPMessageOutputter.MULTI_PART_CONTENT_TYPE + SOAPMessageOutputter.this.getMimeBoundary() + "\"";
            }
            return SOAPMessageOutputter.MULTI_PART_CONTENT_TYPE_P1 + SOAPMessageOutputter.this.mimeStartPartContentID + SOAPMessageOutputter.MULTI_PART_CONTENT_TYPE_P2 + SOAPMessageOutputter.this.getMimeBoundary() + "\"";
        }
    }

    public class SimpleOutputter
    extends Outputter {
        @Override
        protected void write() throws IOException {
            if (!SOAPMessageOutputter.this.doTrustedRequest) {
                SOAPMessageOutputter.this.anEnvelope.writeAsXML(SOAPMessageOutputter.this.outStream);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                SOAPMessageOutputter.this.anEnvelope.writeAsXML(baos);
                SOAPMessageOutputter.this.outStream.write(this.signTrustedRequest(baos.toByteArray()));
            }
        }

        @Override
        protected String getContentType() {
            return SOAPMessageOutputter.TEXT_XML_CONTENT_TYPE;
        }

        @Override
        boolean canResend() {
            return true;
        }
    }

    private abstract class Outputter {
        private CAMUtils camUtils = new CAMUtils();
        private LocalServerConnection localServerConnection;
        protected boolean canResend = false;

        private Outputter() {
        }

        protected byte[] signTrustedRequest(byte[] requestBytes) throws IOException {
            try {
                cat.debug("Signing trusted request as ", SOAPMessageOutputter.this.serviceID);
                return this.camUtils.signRequest(requestBytes, SOAPMessageOutputter.this.serviceID);
            }
            catch (Exception x) {
                cat.error("Exception signing trusted request: ", x);
                throw new IOException("Exception signing trusted request");
            }
        }

        protected abstract void write() throws IOException;

        protected abstract String getContentType();

        boolean canResend() {
            return this.canResend;
        }

        public void setLocalServerConnection(LocalServerConnection localServerConnection) {
            this.localServerConnection = localServerConnection;
        }

        public LocalServerConnection getLocalServerConnection() {
            return this.localServerConnection;
        }

        public void setCanResend(boolean canResend) {
            this.canResend = canResend;
        }
    }
}

