/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.config.AdditionalServiceParameter;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.DomUtils;
import java.util.List;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ConfigurationImpl
implements Configuration {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(ConfigurationImpl.class.getName());
    private ICCLConfiguration icclconfig;
    protected Element cmResponse = null;
    private DispatcherList dispatcherNameList;
    private String currentService = null;
    static final Namespace CRN_NAMESPACE = new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
    static final QName qnParameter = new QName("parameter", CRN_NAMESPACE);
    private boolean forceRunningStateOnReconfigure = false;

    public ConfigurationImpl() {
        this(new DispatcherList());
    }

    public ConfigurationImpl(DispatcherList dispatcherList) {
        this.icclconfig = CCLConfigurationFactory.getInstance();
        this.dispatcherNameList = dispatcherList;
    }

    public ConfigurationImpl(Configuration config) {
        try {
            Element root = config.getICCLConfiguration().getValueElement("", false);
            this.copyAliasRootsProp(config, root);
            this.icclconfig = CCLConfigurationFactory.createConfiguration((Element)root);
            this.icclconfig.init();
            this.cmResponse = config.getCmResponse();
            this.dispatcherNameList = (DispatcherList)config.getDispatcherList();
        }
        catch (Exception e) {
            logger.error("Failed to copy cclconfiguration with exception:  ", (Throwable)e);
            this.icclconfig = CCLConfigurationFactory.createConfiguration();
        }
    }

    public void reconfigure(Element elem) {
        this.cmResponse = elem;
        try {
            this.icclconfig.init(elem);
            this.currentService = null;
        }
        catch (Exception e) {
            this.logFatalError(e, elem);
            throw new RuntimeException(e);
        }
    }

    protected void copyAliasRootsProp(Configuration config, Element root) throws Exception {
        Element value = config.getICCLConfiguration().getValueElement("aliasRoots", false);
        if (value != null) {
            Element param = root.addElement(qnParameter);
            param.addAttribute("name", "aliasRoots");
            param.add(value);
        }
    }

    public String getLocalDispatcherName() {
        return ((DispatcherList)this.getDispatcherList()).getLocalDispatcherName();
    }

    public DispatcherListElement getLocalDispatcherElement() {
        return ((DispatcherList)this.getDispatcherList()).getLocalDispatcherElement();
    }

    public boolean isLocalDispatcherAvailable() {
        return this.getLocalSearchPath() != null;
    }

    public boolean getForceUpdateRunningStateOnReconfigure() {
        return this.forceRunningStateOnReconfigure;
    }

    public void setForceUpdateRunningStateOnReconfigure(boolean forceRunningStateOnReconfigure) {
        this.forceRunningStateOnReconfigure = forceRunningStateOnReconfigure;
    }

    protected void logFatalError(Exception e, Element elem) {
        logger.fatalError("CCL Configuration failed to initialize: ", (Throwable)e);
        logger.fatalError("Initialization document was:\n" + elem.asXML());
    }

    @Override
    public String getValue(String name) {
        try {
            return this.icclconfig.getValue(name, false);
        }
        catch (CCLConfigurationException e) {
            return null;
        }
    }

    public Element getValueElement(String name) {
        try {
            return this.icclconfig.getValueElement(name, true);
        }
        catch (CCLConfigurationException e) {
            return null;
        }
    }

    @Override
    public Element getCmResponse() {
        return this.getCmResponse(this.currentService);
    }

    @Override
    public Element getCmResponse(String serviceName) {
        if (serviceName == null) {
            return this.cmResponse;
        }
        String cmName = "cm:" + serviceName;
        Document cmResponseCopy = DocumentHelper.createDocument((Element)this.cmResponse.createCopy());
        ConfigurationImpl.transferNS(this.cmResponse, cmResponseCopy.getRootElement());
        for (Element serviceElement : this.getQueryResultItems(cmResponseCopy)) {
            String serviceType = serviceElement.attributeValue("type");
            if (serviceType == null || serviceType.equals(cmName) || serviceType.equals("cm:configuration")) continue;
            this.removeAdvancedSettingElement(serviceElement);
        }
        return cmResponseCopy.getRootElement();
    }

    private List<Element> getQueryResultItems(Document cmResponseCopy) {
        return DomUtils.selectElements(cmResponseCopy, "//queryResult/item");
    }

    private static void transferNS(Element src, Element dst) {
        if (!src.isRootElement()) {
            ConfigurationImpl.transferNS(src.getParent(), dst);
        }
        for (Namespace ns : ConfigurationImpl.getDeclaredNamespaces(src)) {
            dst.addNamespace(ns.getPrefix(), ns.getURI());
        }
    }

    private static List<Namespace> getDeclaredNamespaces(Element src) {
        return src.declaredNamespaces();
    }

    private void removeAdvancedSettingElement(Element serviceElement) {
        Element advSetElement = (Element)serviceElement.selectSingleNode("advancedSettings");
        if (advSetElement != null) {
            advSetElement.detach();
        }
    }

    @Override
    public Object getDispatcherList() {
        return this.dispatcherNameList;
    }

    public void setServiceList(Element element) {
        this.dispatcherNameList.createServicesFromElement(element);
    }

    public void addServiceToDispatcherList(String name, String disabled, String parent, String componentID) {
        this.addServiceToDispatcherList(new AdditionalServiceParameter(name, disabled, parent, componentID));
    }

    public void addServiceToDispatcherList(AdditionalServiceParameter parameterObject) {
        this.dispatcherNameList.addServiceToDispatcherList(parameterObject);
    }

    public void setDispatcherList(Element elem) {
        this.dispatcherNameList.reset();
        this.dispatcherNameList.createDispatcherListFromElement(elem);
    }

    @Override
    public ICCLConfiguration getICCLConfiguration() {
        return this.icclconfig;
    }

    public void setCCLConfigurationForTesting(ICCLConfiguration testConfig) {
        this.icclconfig = testConfig;
    }

    @Override
    public void reconfigureForService(String serviceName) {
        if (this.cmResponse == null) {
            return;
        }
        if (!serviceName.equals(this.currentService)) {
            this.currentService = serviceName;
            String cmServiceName = "cm:" + serviceName;
            Element serviceElement = (Element)this.cmResponse.selectSingleNode("//queryResult/item[@xsi:type = '" + cmServiceName + "']/advancedSettings");
            if (serviceElement == null) {
                return;
            }
            Element queryResultElement = DocumentHelper.createElement((String)"queryResult");
            Element itemElement = queryResultElement.addElement("item");
            itemElement.add(serviceElement.createCopy());
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("reinitializing cclconfig for currentService=" + this.currentService + " with: " + queryResultElement.asXML());
                }
                this.icclconfig.init(queryResultElement);
            }
            catch (CCLConfigurationException e) {
                logger.fatalError("ICCLConfiguration.init() failed in reinit for service: " + serviceName, (Throwable)e);
            }
        }
    }

    @Override
    public String getLocalLoadBalancingMode() {
        return this.dispatcherNameList.getLocalLoadBalancingMode();
    }

    @Override
    public String getLocalSearchPath() {
        return this.dispatcherNameList.getLocalSearchPath();
    }

    @Override
    public String getLocalServerGroup() {
        return this.dispatcherNameList.getLocalServerGroup();
    }

    public void setValue(String name, String value) throws CCLConfigurationException {
        Element element = DocumentHelper.createElement((String)"queryResult");
        this.setValueInElement(element, name, value);
        this.icclconfig.init(element);
        this.addToCmResponse(name, value);
    }

    private void setValueInElement(Element element, String name, String value) {
        Element itemElement = element.addElement("item");
        Element nameElement = itemElement.addElement(name);
        Element valueElement = nameElement.addElement("value");
        valueElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        valueElement.setText(value);
    }

    private void addToCmResponse(String name, String value) {
        if (this.cmResponse != null) {
            this.setValueInElement(this.cmResponse, name, value);
        }
    }
}

