/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.config.AdditionalServiceParameter;
import com.cognos.pogo.config.DispatcherListConfiguration;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.DomUtils;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.XmlUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.utils.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DispatcherList {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String QUERY_RESULT = "queryResult";
    private HashMap<String, DispatcherListElement> pathMap = new HashMap();
    private HashMap<String, HashSet<DispatcherListElement>> serverGroupMap = new HashMap();
    private HashMap<String, HashSet<DispatcherListElement>> completeServerGroupMap = new HashMap();
    private String localSearchPath;
    private String localLoadBalancingMode;
    private String localServerGroup;
    private String dispatcherName = PropertyInserter.getProperty("dispatcher.name");
    private Element dispatcherElement;
    private Element serviceElement;

    public String getLocalDispatcherName() {
        return this.dispatcherName;
    }

    public DispatcherListElement getLocalDispatcherElement() {
        DispatcherListElement localDispatcher = null;
        if (this.getLocalDispatcherName() != null) {
            Iterator<DispatcherListElement> elements = null;
            elements = this.getCompleteDispatcherListElements().iterator();
            while (elements.hasNext() && localDispatcher == null) {
                DispatcherListElement element = elements.next();
                if (!this.getLocalDispatcherName().equals(element.toString())) continue;
                localDispatcher = element;
            }
        }
        return localDispatcher;
    }

    public void addDispatcher(String guid, String name, String capacity, String path, String serverGroup, String loadBalancingMode) {
        this.createDispatcherListElement(guid, name, capacity, path, serverGroup, loadBalancingMode, "");
        this.addDispatcherToElement(guid, name, capacity, path, serverGroup, loadBalancingMode);
    }

    private void createDispatcherListElement(String guid, String name, String capacity, String path, String serverGroup, String loadBalancingMode, String edition) {
        DispatcherListElement aListElement = new DispatcherListElement(guid, name, capacity, path, serverGroup, loadBalancingMode, edition);
        this.logDispatcherNameAndServerGroup(name, serverGroup);
        this.pathMap.put(path, aListElement);
        this.addToServerGroupMap(aListElement, serverGroup, this.serverGroupMap);
        this.addToServerGroupMap(aListElement, serverGroup, this.completeServerGroupMap);
    }

    private void logDispatcherNameAndServerGroup(String name, String serverGroup) {
        log.debug("Adding ", name, " to server group ", StringUtils.isEmpty((String)serverGroup) ? "(default)" : serverGroup);
    }

    private void addDispatcherToElement(String guid, String name, String capacity, String path, String serverGroup, String loadBalancingMode) {
        Element itemElement = this.getDispatcherElement().addElement("item");
        itemElement.addElement("dispatcherID").addElement("value").addText(guid);
        itemElement.addElement("dispatcherPath").addElement("value").addText(name);
        itemElement.addElement("capacity").addElement("value").addText(capacity);
        itemElement.addElement("searchPath").addElement("value").addText(path);
        itemElement.addElement("serverGroup").addElement("value").addText(serverGroup);
        itemElement.addElement("loadBalancingMode").addElement("value").addText(loadBalancingMode);
    }

    private Element getDispatcherElement() {
        if (this.dispatcherElement == null) {
            this.dispatcherElement = DocumentHelper.createElement((String)QUERY_RESULT);
        }
        return this.dispatcherElement;
    }

    private void addToServerGroupMap(DispatcherListElement aListElement, String serverGroup, HashMap<String, HashSet<DispatcherListElement>> hashMap) {
        HashSet<DispatcherListElement> serverGroupCollection;
        if (serverGroup == null) {
            serverGroup = "";
        }
        if ((serverGroupCollection = hashMap.get(serverGroup)) == null) {
            serverGroupCollection = new HashSet();
            hashMap.put(serverGroup, serverGroupCollection);
        }
        serverGroupCollection.add(aListElement);
    }

    void addService(String name, String disabled, String parent, String componentID) {
        DispatcherListElement le = this.getDispatcherListElement(parent);
        if (le != null) {
            le.addService(name, disabled, componentID);
        }
    }

    DispatcherListElement getDispatcherListElement(String path) {
        return this.pathMap.get(path);
    }

    public Iterator<DispatcherListElement> getAllDispatcherListElements() {
        return this.pathMap.values().iterator();
    }

    public Collection<DispatcherListElement> getDispatcherListElements() {
        return this.pathMap.values();
    }

    public Collection<DispatcherListElement> getDispatcherListElements(String serverGroup) {
        return this.getFromServerGroup(this.serverGroupMap, serverGroup);
    }

    public Collection<DispatcherListElement> getAllDispatcherListElements(String serverGroup) {
        return this.getFromServerGroup(this.completeServerGroupMap, serverGroup);
    }

    private HashSet<DispatcherListElement> getFromServerGroup(HashMap<String, HashSet<DispatcherListElement>> groupMap, String serverGroup) {
        if (serverGroup == null) {
            return new HashSet<DispatcherListElement>();
        }
        HashSet<DispatcherListElement> serverGroupCollection = groupMap.get(serverGroup);
        if (serverGroupCollection == null) {
            return new HashSet<DispatcherListElement>();
        }
        return serverGroupCollection;
    }

    public Collection<String> getServerGroups() {
        return this.serverGroupMap.keySet();
    }

    public void setServiceElement(Element element) {
        this.serviceElement = element.createCopy();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DispatcherList)) {
            return false;
        }
        DispatcherList list = (DispatcherList)other;
        return this.getDispatcherListConfiguration().equals(list.getDispatcherListConfiguration());
    }

    public void addUnavailableDispatcher(String guid, String name, String capacity, String path, String serverGroup, String loadBalancingMode) {
        DispatcherListElement aListElement = new DispatcherListElement(guid, name, capacity, path, serverGroup, loadBalancingMode);
        aListElement.setAvailable(false);
        this.addToServerGroupMap(aListElement, serverGroup, this.completeServerGroupMap);
    }

    public Collection<String> getCompleteServerGroups() {
        return this.completeServerGroupMap.keySet();
    }

    public HashSet<DispatcherListElement> getCompleteDispatcherListElements() {
        HashSet<DispatcherListElement> retSet = new HashSet<DispatcherListElement>();
        for (HashSet<DispatcherListElement> serverGroupHash : this.completeServerGroupMap.values()) {
            retSet.addAll(serverGroupHash);
        }
        return retSet;
    }

    void createServicesFromElement(Element element) {
        this.logServicesElement(element);
        this.setServiceElement(element);
        for (Element item : this.getItems(element)) {
            String type = item.attributeValue(SOAPEnvelope.XSI_TYPE);
            if (type != null && type.endsWith("runTimeState")) continue;
            String name = this.getTextFromElement(item, "objectClass/value");
            String disabled = this.getTextFromElement(item, "runningState/value");
            String parent = this.getTextFromElement(item, "parent/value/item/searchPath/value");
            String componentID = this.getTextFromElement(item, "componentID/value");
            this.addService(name, disabled, parent, componentID);
        }
    }

    private List<Element> getItems(Element element) {
        return DomUtils.selectElements(element, "item");
    }

    private void logServicesElement(Element element) {
        if (log.isDebugEnabled()) {
            log.debug("Creating services from element ", XmlUtils.prettyPrintAndCatchException(element.asXML()));
        }
    }

    public void createDispatcherListFromElement(Element elem) {
        this.dispatcherElement = elem.createCopy();
        for (Element item : this.getItems(elem)) {
            this.extractDispatcher(item);
        }
    }

    void extractDispatcher(Element item) {
        this.logDispatcherItem(item);
        String name = this.getTextFromElement(item, "dispatcherPath/value");
        String capacity = this.determineCapacity(item);
        String path = this.getTextFromElement(item, "searchPath/value");
        String serverGroup = this.getTextFromElement(item, "serverGroup/value");
        if (serverGroup == null) {
            serverGroup = "";
        }
        String loadBalancingMode = this.getTextFromElement(item, "loadBalancingMode/value");
        String guid = this.getTextFromElement(item, "dispatcherID/value");
        String runningState = this.getTextFromElement(item, "runningState/value");
        String edition = this.getTextFromElement(item, "edition/value");
        if ("standby".equals(runningState) || "disabled".equals(runningState)) {
            log.warn("skipping alien dispatcher ", name, " because its running state is: ", runningState);
            this.addUnavailableDispatcher(guid, name, capacity, path, serverGroup, loadBalancingMode);
        } else {
            this.createDispatcherListElement(guid, name, capacity, path, serverGroup, loadBalancingMode, edition);
            this.checkForLocalDispatcher(name, path, serverGroup, loadBalancingMode);
        }
    }

    private void logDispatcherItem(Element item) {
        if (item != null && log.isDebugEnabled()) {
            log.debug("Extracting dispatcher from item: " + XmlUtils.prettyPrintAndCatchException(item.asXML()));
        }
    }

    private void checkForLocalDispatcher(String name, String path, String serverGroup, String loadBalancingMode) {
        if (name.equalsIgnoreCase(this.dispatcherName)) {
            this.setLocalSearchPath(path);
            this.setLocalServerGroup(serverGroup);
            this.setLocalLoadBalancingMode(loadBalancingMode);
        }
    }

    String determineCapacity(Element disp) {
        Element eCapacity = disp.element("capacity");
        if (this.isCapacityUndefined(eCapacity)) {
            return "1.0";
        }
        return this.getCapacityValue(eCapacity);
    }

    private boolean isCapacityUndefined(Element eCapacity) {
        return eCapacity == null || "nil".equals(eCapacity.attributeValue(SOAPEnvelope.XSI_NIL)) || eCapacity.element("value") == null;
    }

    private String getCapacityValue(Element eCapacity) {
        Element capValue = eCapacity.element("value");
        return capValue.getTextTrim();
    }

    String getTextFromElement(Element item, String path) {
        Element elem = (Element)item.selectSingleNode(path);
        if (elem == null) {
            return null;
        }
        String name = elem.getTextTrim();
        return name;
    }

    public void addServiceToDispatcherList(AdditionalServiceParameter parameterObject) {
        this.addServiceToElement(parameterObject);
        this.addService(parameterObject.getName(), parameterObject.getDisabled(), parameterObject.getParent(), parameterObject.getComponentID());
    }

    private void addServiceToElement(AdditionalServiceParameter parameterObject) {
        if (!this.isItemExist(parameterObject)) {
            Element itemElement = this.getServiceElement().addElement("item");
            itemElement.addElement("objectClass").addElement("value").addText(parameterObject.getName());
            itemElement.addElement("runningState").addElement("value").addText(parameterObject.getDisabled());
            itemElement.addElement("parent").addElement("value").addElement("item").addElement("searchPath").addElement("value").addText(parameterObject.getParent());
            if (parameterObject.getComponentID() != null) {
                itemElement.addElement("componentID").addElement("value").addText(parameterObject.getComponentID());
            }
        } else {
            log.debug("Duplicated Service ");
        }
    }

    private boolean isItemExist(AdditionalServiceParameter serviceParameter) {
        for (Element item : this.getServiceElements()) {
            Attribute attrType = item.attribute("type");
            if (attrType != null || !this.checkIfMatch(this.getElements(item), serviceParameter)) continue;
            return true;
        }
        return false;
    }

    private List<Element> getServiceElements() {
        return this.getElements(this.getServiceElement());
    }

    private List<Element> getElements(Element item) {
        return item.elements();
    }

    private boolean checkIfMatch(List<Element> elements, AdditionalServiceParameter serviceParameter) {
        boolean objectClass = false;
        boolean runningState = false;
        boolean parent = false;
        for (Element e : elements) {
            try {
                String value;
                if ("objectClass".equalsIgnoreCase(e.getName())) {
                    value = e.element("value").getText();
                    if (!serviceParameter.getName().endsWith(value)) continue;
                    objectClass = true;
                    continue;
                }
                if ("runningState".equalsIgnoreCase(e.getName())) {
                    value = e.element("value").getText();
                    if (!serviceParameter.getDisabled().endsWith(value)) continue;
                    runningState = true;
                    continue;
                }
                if (!"parent".equalsIgnoreCase(e.getName())) continue;
                value = e.element("value").element("item").element("searchPath").elementText("value");
                if (!serviceParameter.getParent().endsWith(value)) continue;
                parent = true;
            }
            catch (NullPointerException nullPointerException) {}
        }
        return objectClass && runningState && parent;
    }

    Element getServiceElement() {
        if (this.serviceElement == null) {
            this.serviceElement = DocumentHelper.createElement((String)QUERY_RESULT);
        }
        return this.serviceElement;
    }

    public String getLocalSearchPath() {
        return this.localSearchPath;
    }

    public void setLocalSearchPath(String localSearchPath) {
        this.localSearchPath = localSearchPath;
    }

    public String getLocalServerGroup() {
        return this.localServerGroup;
    }

    void setLocalServerGroup(String localServerGroup) {
        this.localServerGroup = localServerGroup;
    }

    public String getLocalLoadBalancingMode() {
        return this.localLoadBalancingMode;
    }

    void setLocalLoadBalancingMode(String localLoadBalancingMode) {
        this.localLoadBalancingMode = localLoadBalancingMode;
    }

    public void reset() {
        this.pathMap.clear();
        this.serverGroupMap.clear();
        this.completeServerGroupMap.clear();
        this.localSearchPath = null;
    }

    public DispatcherListConfiguration getDispatcherListConfiguration() {
        return new DispatcherListConfiguration(this.getDispatcherElement(), this.getServiceElement());
    }

    public String getDispListForTesting() {
        return this.pathMap.values().toString();
    }

    public void setLocalDispatcher(String dispatcher) {
        this.dispatcherName = dispatcher;
    }
}

