/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.pdk.PogoException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;
import org.dom4j.Node;

public class DispatcherNameParser {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(DispatcherNameParser.class.getName());
    private String objectPath;
    protected ContentManagerQueryCommand query;
    protected String host = null;
    protected int port;
    protected boolean ssl = false;
    protected String requestPath = null;
    private boolean queriedCM = false;

    public DispatcherNameParser(String objectPath) {
        this.objectPath = objectPath;
        this.query = new ContentManagerQueryCommand(objectPath);
    }

    public String getHost() throws PogoException {
        if (this.host == null) {
            this.queryCM();
        }
        return this.host;
    }

    public int getPort() throws PogoException {
        if (this.port == 0) {
            this.queryCM();
        }
        return this.port;
    }

    public String getService() {
        return null;
    }

    public boolean getSsl() {
        return this.ssl;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    protected void queryCM() throws PogoException {
        if (this.queriedCM) {
            return;
        }
        this.queriedCM = true;
        try {
            this.doQuery();
        }
        catch (SoapFaultException sfe) {
            cat.error("DispatcherNameParser parse failure", (Throwable)sfe);
            throw new PogoException(sfe.getDetail(), sfe);
        }
        catch (CommandExecutionException e) {
            cat.error("DispatcherNameParser parse failure", (Throwable)e);
            throw new PogoException(e.getMessage(), e);
        }
    }

    protected void doQuery() throws CommandExecutionException {
        this.query.addQueryPropertyName("dispatcherPath");
        this.query.setDoTrustedRequest(true);
        this.query.execute();
        Element elem = this.query.getQueryResponseElement();
        this.parseResult(elem);
    }

    void parseResult(Element elem) {
        this.getHostPort(elem);
    }

    protected void getHostPort(Element elem) {
        Node pathNode = elem.selectSingleNode("//dispatcherPath/value");
        if (pathNode != null) {
            String path = pathNode.getText();
            this.extractHostPort(path);
        }
    }

    protected void extractHostPort(String name) {
        int http = name.indexOf("//") + 2;
        int bracket = name.indexOf("]", http);
        int colon = bracket != -1 ? name.indexOf(":", bracket) : name.indexOf(":", http);
        this.ssl = name.startsWith("https:");
        this.host = name.substring(http, colon);
        int slash = name.indexOf(47, colon);
        this.port = Integer.parseInt(name.substring(colon + 1, slash));
        this.requestPath = name.substring(slash) + PropertyInserter.getProperty("dispatcher.scriptname");
    }

    public String getRequestPath() throws PogoException {
        if (this.requestPath == null) {
            this.queryCM();
        }
        return this.requestPath;
    }
}

