/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.pogo.handlers.logic.NoopHandler;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.PogoConfigException;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoIPFLog;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class HandlerFactory {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(HandlerFactory.class.getName());

    public static Handler create(Element e) throws PogoException {
        return HandlerFactory.create(e, null);
    }

    public static Handler create(Element e, ClassLoader classLoader) throws PogoException {
        String name = e.attributeValue("name");
        if (name == null || name.length() == 0) {
            String errorMsg = DispatcherStrings.getInstance().getString("HandlerFactory.noName");
            throw new PogoConfigException(errorMsg);
        }
        String classname = e.attributeValue("classname");
        if (classname == null || classname.length() == 0) {
            Object[] args = new Object[]{name};
            String errorMsg = DispatcherStrings.getInstance().getString("HandlerFactory.noClass", args);
            throw new PogoConfigException(errorMsg);
        }
        cat.debug("creating pogo handler " + name + " of type " + classname);
        Handler h = HandlerFactory.createHandler(name, classname, classLoader);
        h.setName(name);
        h.contextualize(e);
        return h;
    }

    private static Handler createHandler(String name, String classname, ClassLoader classLoader) {
        Object o;
        try {
            o = HandlerFactory.createClassInstance(classname, classLoader);
        }
        catch (Throwable x) {
            cat.error("cannot instantiate handler class " + classname + ", substituted Noophandler", x);
            Object[] args = new Object[]{name, classname};
            String errorMsg = DispatcherStrings.getInstance().getString("HandlerFactory.cantInstantiate", args);
            PogoIPFLog.getInstance().logStartupError(errorMsg);
            o = new NoopHandler();
        }
        if (!(o instanceof Handler)) {
            cat.error("classname \"" + classname + "\" does not implement com.cognos.pogo.pdk.Handler, substituted Noophandler");
            Object[] args = new Object[]{name, classname};
            String errorMsg = DispatcherStrings.getInstance().getString("HandlerFactory.notHandler", args);
            PogoIPFLog.getInstance().logStartupError(errorMsg);
            o = new NoopHandler();
        }
        return (Handler)o;
    }

    private static Object createClassInstance(String classname, ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = classLoader == null ? Class.forName(classname) : Class.forName(classname, false, classLoader);
        return clazz.newInstance();
    }
}

