/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.pogo.bibus.BIBusResponse;
import com.cognos.pogo.config.DispatcherNameParser;
import com.cognos.pogo.config.ServiceAdminCommand;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.util.PogoIPFLog;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class StartServiceAdminCommand
extends ServiceAdminCommand {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(StartServiceAdminCommand.class.getName());

    public StartServiceAdminCommand(Element e, MessageContext mc, PogoEngine engine) {
        super(e, mc, engine);
    }

    @Override
    public boolean executeImpl(BIBusResponse response) {
        this.setNeedToUpdateDispatcherStatus("true");
        try {
            DispatcherNameParser parser = this.getNameParser();
            this.doStartService(parser.getService(), parser.getObjectPath());
            return true;
        }
        catch (Exception e) {
            String msg = this.formatExceptionMessage("StartServiceAdminCommand.startFailed", e);
            response.addFault(msg);
            return false;
        }
    }

    private void doStartService(String serviceName, String servicePath) throws PogoException {
        if (!this.checkServiceWithCM(servicePath)) {
            String msg = DispatcherStrings.getInstance().getString("startService.requestNotAllowed");
            throw new PogoException(msg);
        }
        Service service = this.getService(serviceName);
        PogoIPFLog.getInstance().logServiceChange(servicePath, "StartService");
        service.resume();
    }

    @Override
    String getResponseName() {
        return "startServiceResponse";
    }
}

