/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.pogo.bibus.BIBusResponse;
import com.cognos.pogo.config.DispatcherNameParser;
import com.cognos.pogo.config.ServiceAdminCommand;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.util.PogoIPFLog;
import java.util.Locale;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class StopServiceAdminCommand
extends ServiceAdminCommand {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(StopServiceAdminCommand.class.getName());

    public StopServiceAdminCommand(Element e, MessageContext mc, PogoEngine engine) {
        super(e, mc, engine);
    }

    @Override
    public boolean executeImpl(BIBusResponse response) {
        this.setNeedToUpdateDispatcherStatus("true");
        String immediate = this.getCommandElement().element("immediately").getText();
        try {
            DispatcherNameParser parser = this.getNameParser();
            this.doStopService(parser.getService(), parser.getObjectPath(), Boolean.valueOf(immediate));
            return true;
        }
        catch (Exception e) {
            String msg = this.formatExceptionMessage("StopServiceAdminCommand.stopFailed", e);
            response.addFault(msg);
            return false;
        }
    }

    private void doStopService(String serviceName, String servicePath, boolean immediate) throws PogoException {
        Service service = this.getService(serviceName);
        if (!service.isSuspendable()) {
            String msg = DispatcherStrings.getInstance().getString("SERVICE_CANNOT_BE_STOPPED", (Locale)this.messageContext.getProperty("locale"));
            throw new PogoException(msg);
        }
        if (!this.checkServiceWithCM(servicePath)) {
            String msg = DispatcherStrings.getInstance().getString("stopService.requestNotAllowed");
            throw new PogoException(msg);
        }
        PogoIPFLog.getInstance().logServiceChange(servicePath, "StopService");
        service.suspend(immediate);
    }

    @Override
    String getResponseName() {
        return "stopServiceResponse";
    }
}

