/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager;

import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.contentmanager.coordinator.ActiveCMControl;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.Tracking;
import com.cognos.pogo.pdk.common.BodyFaultException;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.pogo.transport.FormRequestProcessor;
import java.util.List;

public abstract class ContentManagerCommand
extends BIBusCommand {
    private boolean continueOnError;
    private int connectionTimeout = -1;
    private final ActiveCMControl activeCMControl;

    public ContentManagerCommand() {
        this(null);
    }

    public ContentManagerCommand(MessageContext mc) {
        this(mc, ActiveCMControl.getInstance());
    }

    public ContentManagerCommand(MessageContext mc, ActiveCMControl activeCMControl) {
        super(mc);
        this.setAutoRetry(false);
        this.activeCMControl = activeCMControl;
    }

    @Override
    protected ServerConnection fetchServerConnection() {
        ServerConnection contentManagerConnection = DispatcherConnectionManager.getContentManagerConnection();
        if (this.connectionTimeout != -1) {
            contentManagerConnection.setConnectionTimeout(this.connectionTimeout);
        }
        return contentManagerConnection;
    }

    @Override
    protected String fetchRequestContext() {
        return NodeIdGuidMapper.getContentManagerNID().getPath();
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    boolean isContinueOnError() {
        return this.continueOnError;
    }

    @Override
    protected void addExtraHTTPHeaders(ServerConnection connection) {
        connection.addRequestHeader("SOAPAction", FormRequestProcessor.CONTENT_MANAGER_SERVICE);
    }

    @Override
    protected void addExtraSOAPHeaders() {
        this.getRequestEnvelope().setDispatcherTransport("requester", "DISP");
    }

    protected void addSessionRequestIds(String tag) {
        BIBusEnvelope requestEnv = this.getRequestEnvelope();
        requestEnv.setSessionContext(Tracking.getInstance().generateSessionContext(tag));
        requestEnv.setRequestContext(Tracking.getInstance().generateRequestContext(null));
    }

    @Override
    protected boolean checkForInactiveCM() {
        BodyFaultException exception = this.getFirstException();
        return exception != null && this.isCmInStandby(exception);
    }

    private BodyFaultException getFirstException() {
        List<BodyFaultException> exceptions = this.getResponseEnvelope().getBodyFault().getDetail().getExceptions();
        return exceptions.isEmpty() ? null : exceptions.get(0);
    }

    private boolean isCmInStandby(BodyFaultException exception) {
        String errorCode = exception.getErrorCode();
        this.checkCmControl(errorCode);
        return "cmInStandByMode".equals(errorCode);
    }

    private void checkCmControl(String errorCodeText) {
        if ("cmInStandByMode".equals(errorCodeText) || "cmStoreNotAvailable".equals(errorCodeText)) {
            this.activeCMControl.soapFaultNotify();
        }
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

