/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.DomUtils;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.QName;

public class ContentManagerMultipleQueryCommand
extends ContentManagerQueryCommand {
    private static final QName BUS_REQUESTS = new QName("requests", BUS_NAMESPACE);
    protected static final String QUERY_REQUEST = BIBusEnvelope.NS_BUS.getPrefix() + ":queryRequest";
    protected static final QName BUS_ITEM = new QName("item", BUS_NAMESPACE);
    private List<Element> responseList;
    private ArrayList<QueryObjectProperties> objectPropertiesList = new ArrayList();

    public ContentManagerMultipleQueryCommand(String objectName) {
        super(objectName);
    }

    @Override
    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        Element requests = this.createRequestsElement(bodyElement);
        Element queryElement = ContentManagerMultipleQueryCommand.addQueryItemToElement(requests);
        this.addSearchElements(queryElement);
        for (QueryObjectProperties element : this.objectPropertiesList) {
            this.addQueryElement(requests, element.queryObject, element.queryProperties);
        }
    }

    public static Element addQueryItemToElement(Element requests) {
        Element queryElement = requests.addElement(BUS_ITEM);
        queryElement.addAttribute(SOAPEnvelope.XSI_TYPE, QUERY_REQUEST);
        return queryElement;
    }

    public static Element pasteQueryItemToElementFromSingleSearch(Element singleSearch, Element requests) {
        Element queryElement = singleSearch.createCopy(BUS_ITEM);
        queryElement.addAttribute(SOAPEnvelope.XSI_TYPE, QUERY_REQUEST);
        requests.add(queryElement);
        return queryElement;
    }

    protected Element createRequestsElement(Element bodyElement) {
        Element multiQuery = bodyElement.addElement(BUS_QUERY);
        return ContentManagerMultipleQueryCommand.addRequestsElement(multiQuery);
    }

    public static Element addRequestsElement(Element multiQuery) {
        Element requests = multiQuery.addElement(BUS_REQUESTS);
        requests.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        requests.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, QUERY_REQUEST + "[]");
        return requests;
    }

    protected Element addQueryElement(Element requests, String queryObjectName, String[] queryProperty) {
        Element modTimeElement = ContentManagerMultipleQueryCommand.addQueryItemToElement(requests);
        Element searchElement = modTimeElement.addElement("search");
        searchElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        searchElement.setText(queryObjectName);
        Element propertiesElement = modTimeElement.addElement("properties");
        propertiesElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        propertiesElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum[" + queryProperty.length + "]");
        for (int i = 0; i < queryProperty.length; ++i) {
            Element propItem = propertiesElement.addElement(BUS_ITEM);
            propItem.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
            propItem.setText(queryProperty[i]);
        }
        return modTimeElement;
    }

    public int addSearchProperties(String queryObject, String[] queryProperties) {
        this.objectPropertiesList.add(new QueryObjectProperties(queryObject, queryProperties));
        return this.objectPropertiesList.size();
    }

    @Override
    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
        this.setResponseList(bodyElement);
    }

    void setResponseList(Element bodyElement) {
        this.responseList = DomUtils.selectElements(bodyElement, "//queryResult");
    }

    public String getValue(int part, String property) {
        Element value = this.getValueElement(part, property);
        if (value != null) {
            return value.getTextTrim();
        }
        return null;
    }

    public Element getValueElement(int part, String property) {
        Element element;
        Element itemElement;
        Element e = this.responseList.get(part);
        if (e != null && (itemElement = e.element("item")) != null && (element = itemElement.element(property)) != null) {
            return element.element("value");
        }
        return null;
    }

    public boolean hasValue(int part) {
        Element e = this.responseList.get(part);
        return e != null && e.hasContent();
    }

    public void reset() {
        this.objectPropertiesList.clear();
    }

    private class QueryObjectProperties {
        private String queryObject;
        private String[] queryProperties;

        public QueryObjectProperties(String queryObject, String[] queryProperties) {
            this.queryObject = queryObject;
            this.queryProperties = queryProperties;
        }
    }
}

