/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.http.ConnectionPool;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.util.Check;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class PogoConnectionFactory {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(PogoConnectionFactory.class.getName());
    private static PogoConnectionFactory instance = new PogoConnectionFactory();
    private ConnectionPool contentManagerConnectionPool = null;
    private Object mutex = new Object();

    private void initializeConnectionPools() {
        String host = "localhost";
        int port = 9300;
        NodeID cmNID = NodeIdGuidMapper.getContentManagerNID();
        if (null != cmNID) {
            host = cmNID.getHost();
            boolean ssl = cmNID.getProtocol().equals("https");
            port = cmNID.getPort();
            String sOverridePort = PropertyInserter.getProperty("cm.port.override");
            if (sOverridePort != null && sOverridePort.length() > 0) {
                try {
                    port = Integer.parseInt(sOverridePort);
                    logger.warn("!!!! CM port forced to " + sOverridePort + " for debug purposes.");
                }
                catch (NumberFormatException nfx) {
                    logger.error("!!!! CM override port \"" + sOverridePort + "\" is invalid.");
                }
            }
            Check.inRange(port, 1L, 65536L);
            PogoConnectionFactory.instance.contentManagerConnectionPool = new ConnectionPool(host, port, ssl, 0);
        } else {
            PogoConnectionFactory.instance.contentManagerConnectionPool = new ConnectionPool(host, port, false, 0);
        }
    }

    private PogoConnectionFactory() {
    }

    public static PogoConnectionFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConnection getContentManagerConnection() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.contentManagerConnectionPool == null) {
                this.initializeConnectionPools();
            }
        }
        return this.contentManagerConnectionPool.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCMConnectionPool() {
        ConnectionPool temp = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.contentManagerConnectionPool != null) {
                temp = this.contentManagerConnectionPool;
                this.contentManagerConnectionPool = null;
            }
        }
        if (temp != null) {
            temp.dispose();
        }
    }
}

