/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.contentmanager.ContentManagerCommand;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.pogo.util.Check;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public abstract class StandbyContentManagerCommand
extends ContentManagerCommand {
    protected NodeID nodeID;
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(StandbyContentManagerCommand.class.getName());

    public StandbyContentManagerCommand(NodeID nodeID) {
        this.nodeID = nodeID;
    }

    @Override
    protected ServerConnection fetchServerConnection() {
        int port = this.nodeID.getPort();
        String sOverridePort = PropertyInserter.getProperty("cm.port.override");
        if (sOverridePort != null && sOverridePort.length() > 0) {
            try {
                port = Integer.parseInt(sOverridePort);
                cat.warn("!!!! CM port forced to " + sOverridePort + " for debug purposes.");
            }
            catch (NumberFormatException nfx) {
                cat.error("!!!! CM override port \"" + sOverridePort + "\" is invalid.");
            }
        }
        Check.inRange(port, 1L, 65536L);
        boolean requiresSSL = this.nodeID.getProtocol().equals("https");
        return DispatcherConnectionManager.getStandaloneConnection(this.nodeID.getHost(), port, requiresSSL);
    }

    @Override
    protected String fetchRequestContext() {
        return this.nodeID.getPath();
    }

    @Override
    protected boolean checkForInactiveCM() {
        return false;
    }
}

