/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CacheElement;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CacheElementMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 4971537316239315975L;
    private Map<K, V> map;
    private final CacheElement owner;

    public CacheElementMap(CacheElement owner) {
        this(owner, new ConcurrentHashMap());
    }

    public CacheElementMap(CacheElement owner, int initialCapacity) {
        this(owner, new ConcurrentHashMap(initialCapacity));
    }

    public CacheElementMap(CacheElement owner, Map<K, V> map) {
        if (map == null || owner == null) {
            throw new NullPointerException();
        }
        this.owner = owner;
        this.map = map;
        owner.updateAccessTime();
    }

    public Object getMutex() {
        this.owner.updateAccessTime();
        return this.map;
    }

    @Override
    public void clear() {
        this.owner.updateAccessTime();
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.owner.updateAccessTime();
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.owner.updateAccessTime();
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.owner.updateAccessTime();
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        this.owner.updateAccessTime();
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        this.owner.updateAccessTime();
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.owner.updateAccessTime();
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        this.owner.updateAccessTime();
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.owner.updateAccessTime();
        this.map.putAll(t);
    }

    @Override
    public V remove(Object key) {
        this.owner.updateAccessTime();
        return this.map.remove(key);
    }

    @Override
    public int size() {
        this.owner.updateAccessTime();
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        this.owner.updateAccessTime();
        return this.map.values();
    }
}

