/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.HandlerConfig;
import com.cognos.pogo.util.timer.PogoTime;
import org.apache.commons.lang.StringUtils;

public class CacheValidator {
    public static final long DEFAULT_TIME_TO_LIVE = 300000L;
    public static final long DEFAULT_TIME_TO_LINGER = 30000L;
    private static long timeToLive = 300000L;
    private static long timeToLinger = 30000L;
    private static final int LINGER_EXPIRED = 0;
    private static PogoTime cacheTime = new PogoTime();
    private final String validator;
    private long expiryTime;
    private long lingerTime;

    public CacheValidator(String validator) {
        this.validator = validator;
        this.resetExpiryTime();
        this.resetLingerTime();
    }

    public void expireLingerTime() {
        this.lingerTime = 0L;
    }

    public void resetExpiryTime() {
        this.expiryTime = cacheTime.getCurrentTime() + timeToLive;
    }

    public void resetLingerTime() {
        this.lingerTime = cacheTime.getCurrentTime() + timeToLinger;
    }

    public String getValidator() {
        return this.validator;
    }

    public boolean isExpired() {
        return cacheTime.getCurrentTime() >= this.expiryTime;
    }

    public boolean isLingering() {
        return cacheTime.getCurrentTime() < this.lingerTime;
    }

    public boolean equals(Object other) {
        CacheValidator otherCacheValidator = other instanceof CacheValidator ? (CacheValidator)other : null;
        return otherCacheValidator != null && StringUtils.equals((String)this.validator, (String)otherCacheValidator.validator);
    }

    public static void setCacheTime(PogoTime cacheTime) {
        CacheValidator.cacheTime = cacheTime;
    }

    public static void updateConfiguration(HandlerConfig config) {
        timeToLive = config.getCacheValidatorTimeToLive();
        timeToLinger = config.getCacheValidatorTimeToLinger();
    }

    public static long getTimeToLive() {
        return timeToLive;
    }

    public static long getTimeToLinger() {
        return timeToLinger;
    }
}

