/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CMCachePerfLoggerFactory;
import com.cognos.pogo.contentmanager.cache.HandlerConfig;
import com.cognos.pogo.contentmanager.cache.HandlerSession;
import com.cognos.pogo.contentmanager.cache.ResponseCache;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.performance.PerformanceIndicator;
import com.cognos.pogo.pdk.performance.listener.PerformanceEventListener;
import com.cognos.pogo.util.PerfLogger;
import com.cognos.pogo.util.PerfTimer;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.XmlUtils;

public abstract class DispatcherSession
implements HandlerSession {
    private final MessageContext messageContext;
    private final ResponseCache responseCache;
    private final HandlerConfig handlerConfig;
    private final PerfLogger perfLogger;
    private Envelope requestEnvelope;
    private SearchParameters searchParameters;
    private String passport;

    public DispatcherSession(MessageContext messageContext, ResponseCache responseCache, HandlerConfig hc) {
        this.messageContext = messageContext;
        this.responseCache = responseCache;
        this.handlerConfig = hc;
        this.perfLogger = CMCachePerfLoggerFactory.createPerfLogger(this.getClass(), messageContext);
    }

    protected abstract PogoLogger getLog();

    protected abstract String getRequestName();

    protected abstract void processRequest();

    protected abstract void createSearchParameters();

    protected abstract void logRequest();

    @Override
    public void handleRequest() {
        PerfTimer timer = this.startPerfTimer(PerfLogger.Level.LEVEL1, "handleRequest", new Object[0]);
        try {
            this.extractRequestParameters();
            this.processRequest();
        }
        catch (Exception e) {
            this.sendSoapFault("Error while handling " + this.getRequestName() + " request", e);
        }
        finally {
            this.stopPerfTimer(timer);
        }
    }

    protected PerfTimer startPerfTimer(PerfLogger.Level level, String method, Object ... objects) {
        return this.getPerfLogger().startTimer(level, method, objects);
    }

    protected void stopPerfTimer(PerfTimer timer) {
        this.getPerfLogger().stopTimer(timer);
    }

    protected PerfLogger getPerfLogger() {
        return this.perfLogger;
    }

    private void extractRequestParameters() {
        PerfTimer timer = this.startPerfTimer(PerfLogger.Level.LEVEL4, "extractRequestParameters", new Object[0]);
        this.requestEnvelope = (BIBusEnvelope)this.messageContext.getProperty("request.envelope");
        this.passport = this.requestEnvelope.getBiBusHeader().getCam().getCAMPassport().getId();
        this.createSearchParameters();
        this.updatePerformanceIndicator();
        this.tryToLogRequest();
        this.stopPerfTimer(timer);
    }

    protected void sendSoapFault(String faultMessage, Exception rootCauseException) {
        this.messageContext.setFault(new Fault(faultMessage, rootCauseException));
        this.getLog().warn(faultMessage, rootCauseException);
    }

    private void updatePerformanceIndicator() {
        PerformanceEventListener pi = PerformanceIndicator.getListener();
        pi.handleObjectPath(this.searchParameters.getObjectPath());
    }

    private void tryToLogRequest() {
        if (this.getLog().isDebugEnabled()) {
            try {
                this.logRequest();
            }
            catch (Exception e) {
                this.getLog().debug("Error logging request envelope: ", e);
            }
        }
    }

    public String getPassport() {
        return this.passport;
    }

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    public void setSearchParameters(SearchParameters searchParameters) {
        this.searchParameters = searchParameters;
    }

    protected ResponseCache getResponseCache() {
        return this.responseCache;
    }

    public Envelope getRequestEnvelope() {
        return this.requestEnvelope;
    }

    protected void setResponseEnvelope(SOAPEnvelope responseEnvelope) {
        this.messageContext.setResponseName("response");
        this.messageContext.setProperty("response.envelope", responseEnvelope);
        this.messageContext.setProperty("response.status_code", "200");
        this.logResponse(responseEnvelope);
    }

    private void logResponse(SOAPEnvelope responseEnvelope) {
        if (this.getLog().isDebugEnabled()) {
            try {
                this.getLog().debug("Sending response to the client: ", XmlUtils.prettyPrint(responseEnvelope.getAsString()));
            }
            catch (Exception e) {
                this.getLog().debug("Error logging response to the client: ", e);
            }
        }
    }
}

