/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CacheParameter;
import com.cognos.pogo.contentmanager.cache.CacheServiceConfiguration;
import com.cognos.pogo.contentmanager.cache.HeapLimit;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.stax.connection.SOAPConnectionFactory;
import com.cognos.pogo.stax.connection.SOAPConnectionFactoryImpl;
import com.cognos.pogo.util.PogoLogger;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.log.Priority;

public class HandlerConfig
implements CacheServiceConfiguration {
    static final int DEFAULT_HEAP_LIMIT_PERCENTAGE = 10;
    static final long DEFAULT_ACCOUNT_INACTIVITY_TIMER = 900000L;
    private static PogoLogger log = PogoLogger.getLogger();
    private final Configuration config;
    private String cmPath;
    private String auditLevel;
    private int heapLimit;
    private long cacheValidatorTimeToLive;
    private long cacheValidatorTimeToLinger;
    private long accountInactivityTimer;
    private SOAPConnectionFactory soapConnectionFactory;

    public HandlerConfig(Configuration config) throws Exception {
        this.config = config;
        this.setCMPath();
        this.setAuditLevel();
        this.setHeapLimit();
        this.setCacheValidatorTimeToLive();
        this.setCacheValidatorTimeToLinger();
        this.setAccountInactivityTimer();
        this.createConnectionFactory();
    }

    private void setCMPath() throws Exception {
        String contentManager = this.config.getValue("contentManager");
        this.cmPath = StringUtils.isEmpty((String)contentManager) ? null : new URL(contentManager).getFile();
        log.info("cmPath set to: ", this.cmPath);
    }

    private void setAuditLevel() throws Exception {
        this.auditLevel = this.config.getValue("cmcsAuditLevel");
        log.info("auditLevel set to: ", this.auditLevel);
    }

    private void setHeapLimit() throws Exception {
        HeapLimit heapLimitParameter = new HeapLimit(String.valueOf(10));
        heapLimitParameter.updateConfiguration(this.config);
        this.heapLimit = this.parseHeapLimit(heapLimitParameter.getValue());
        log.info("Using heapLimit = ", heapLimitParameter.getValue(), "% of available heap.");
    }

    private int parseHeapLimit(String stringValue) {
        try {
            return Integer.parseInt(stringValue);
        }
        catch (Exception e) {
            log.warn("Invalid cmcsHeapLimit: ", stringValue);
            return 10;
        }
    }

    private void setCacheValidatorTimeToLive() throws Exception {
        this.cacheValidatorTimeToLive = this.getCacheParameter("cacheValidatorTimeToLive", 300000L);
    }

    private void setCacheValidatorTimeToLinger() throws Exception {
        this.cacheValidatorTimeToLinger = this.getCacheParameter("cacheValidatorTimeToLinger", 30000L);
    }

    private void setAccountInactivityTimer() throws Exception {
        this.accountInactivityTimer = this.getCacheParameter("accountInactivityTimer", 900000L);
    }

    private long getCacheParameter(String parameterName, long defaultValue) {
        CacheParameter cacheParameter = new CacheParameter("." + parameterName, String.valueOf(defaultValue));
        cacheParameter.updateConfiguration(this.config);
        return this.parseLong(parameterName, cacheParameter.getValue(), defaultValue);
    }

    private long parseLong(String parameterName, String stringValue, long defaultValue) {
        try {
            long longValue = Long.parseLong(stringValue);
            log.info("Using ", parameterName, " = ", longValue);
            return longValue;
        }
        catch (Exception e) {
            log.warn("Invalid ", parameterName, ": ", stringValue);
            return defaultValue;
        }
    }

    public long getCacheValidatorTimeToLive() {
        return this.cacheValidatorTimeToLive;
    }

    @Override
    public long getCacheValidatorTimeToLinger() {
        return this.cacheValidatorTimeToLinger;
    }

    private void createConnectionFactory() {
        this.soapConnectionFactory = new SOAPConnectionFactoryImpl(this.cmPath, "/p2pd/servlet/dispatch");
    }

    public SOAPConnectionFactory getSoapConnectionFactory() {
        return this.soapConnectionFactory;
    }

    public String getCMPath() {
        return this.cmPath;
    }

    public String getAuditLevel() {
        return this.auditLevel;
    }

    @Override
    public boolean isEnabled() {
        return this.getHeapLimit() > 0;
    }

    @Override
    public int getHeapLimit() {
        return this.heapLimit;
    }

    public long getAccountInactivityTimer() {
        return this.accountInactivityTimer;
    }

    public void setSoapConnectionFactoryForTesting(SOAPConnectionFactory soapConnectionFactory) {
        this.soapConnectionFactory = soapConnectionFactory;
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }
}

