/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CacheElement;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.List;

public class Items
extends CacheElement {
    private List<String> names = new ArrayList<String>();
    private List<String> values = new ArrayList<String>();

    public synchronized void put(String name, String value) {
        this.names.add(name);
        this.values.add(value);
    }

    public synchronized String get(String name) {
        for (int i = 0; i < this.names.size(); ++i) {
            if (!this.names.get(i).equals(name)) continue;
            return this.values.get(i);
        }
        return null;
    }

    public synchronized List<String> getValues() {
        return new ArrayList<String>(this.values);
    }

    public synchronized List<String> getValuesFor(String name) {
        ArrayList<String> valuesForName = new ArrayList<String>();
        for (int i = 0; i < this.names.size(); ++i) {
            if (!this.names.get(i).equals(name)) continue;
            valuesForName.add(this.values.get(i));
        }
        return valuesForName;
    }

    public synchronized List<String> getNames() {
        return new ArrayList<String>(this.names);
    }

    public synchronized void writeNamesAndValuesTo(List<String> itemNames, List<String> itemValues) {
        itemNames.addAll(this.names);
        itemValues.addAll(this.values);
    }

    public synchronized boolean isEmpty() {
        return this.names.isEmpty();
    }

    protected synchronized void clear() {
        this.names.clear();
        this.values.clear();
    }

    public synchronized void intern() {
        for (int i = 0; i < this.names.size(); ++i) {
            this.names.set(i, this.intern(this.names.get(i)));
            this.values.set(i, this.intern(this.values.get(i)));
        }
    }

    @Override
    public synchronized void dump(PogoLogger log, String indent) {
        super.dump(log, indent);
        indent = indent + "   ";
        for (int i = 0; i < this.names.size(); ++i) {
            log.debug(indent, "name: ", this.names.get(i));
            log.debug(indent, "value: ", this.getStringForLogging(this.values.get(i)));
        }
    }
}

