/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CacheElement;
import com.cognos.pogo.contentmanager.cache.Model;
import com.cognos.pogo.contentmanager.cache.SearchPathUtils;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Models
extends CacheElement {
    private static final String MODEL_LAST = "model[last()]";
    private final Map<String, Model> modelsByName = Collections.synchronizedMap(new HashMap());
    private Model lastModel;

    public void saveModel(String modelSearchPath, String itemBody) {
        String modelName = SearchPathUtils.getModelName(modelSearchPath);
        this.lastModel = new Model(modelName, itemBody);
        this.saveModel(this.lastModel);
    }

    private void saveModel(Model model) {
        this.saveModel(model.getKey(), model);
    }

    private void saveModel(String modelName, Model model) {
        this.modelsByName.put(modelName, model);
    }

    public void saveModelView(String modelViewSearchPath, String itemBody) {
        String modelSearchPath = SearchPathUtils.getModelFromModelView(modelViewSearchPath);
        Model model = this.getModel(modelSearchPath);
        if (model != null) {
            model.saveModelView(modelViewSearchPath, itemBody);
        }
    }

    public Model getModel(String modelSearchPath) {
        if (modelSearchPath == null) {
            return null;
        }
        String modelName = SearchPathUtils.getModelName(modelSearchPath);
        return modelName.equals(MODEL_LAST) ? this.lastModel : this.modelsByName.get(modelName);
    }

    public void importModelsFromTheCache(Models modelsFromTheCache) {
        for (Model model : modelsFromTheCache.getModelList()) {
            this.saveModel(model);
        }
        this.lastModel = modelsFromTheCache.lastModel;
    }

    public boolean isEmpty() {
        return this.modelsByName.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Model> getModelList() {
        Map<String, Model> map = this.modelsByName;
        synchronized (map) {
            return new ArrayList<Model>(this.modelsByName.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllItems() {
        ArrayList<String> items = new ArrayList<String>();
        Map<String, Model> map = this.modelsByName;
        synchronized (map) {
            for (Model model : this.modelsByName.values()) {
                this.addModelAndModelViews(model, items);
            }
        }
        return items;
    }

    private void addModelAndModelViews(Model model, List<String> items) {
        items.add(model.getModelItemValue());
        items.addAll(model.getAllModelViewItemValues());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intern() {
        Map<String, Model> map = this.modelsByName;
        synchronized (map) {
            HashMap<String, Model> snapshot = new HashMap<String, Model>(this.modelsByName);
            this.modelsByName.clear();
            for (Map.Entry entry : snapshot.entrySet()) {
                String modelName = (String)entry.getKey();
                Model model = (Model)entry.getValue();
                this.saveModel(this.intern(modelName), model.intern());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemovalFromCache() {
        super.handleRemovalFromCache();
        Map<String, Model> map = this.modelsByName;
        synchronized (map) {
            for (Model model : this.modelsByName.values()) {
                model.handleRemovalFromCache();
            }
        }
    }

    @Override
    public void dump(PogoLogger log, String indent) {
        super.dump(log, indent);
        indent = indent + "   ";
        for (Model model : this.getModelList()) {
            model.dump(log, indent);
        }
    }
}

