/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.AccountCache;
import com.cognos.pogo.contentmanager.cache.CacheContainer;
import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.PackageItems;
import com.cognos.pogo.contentmanager.cache.ReportCache;
import com.cognos.pogo.contentmanager.cache.ReportItems;
import com.cognos.pogo.util.PogoLogger;

public class PackageCache
extends CacheContainer {
    public PackageCache(CacheContainer parent, PackageItems packageItems) {
        super(parent, packageItems);
    }

    @Override
    public AccountCache getParent() {
        return (AccountCache)super.getParent();
    }

    public PackageItems getPackageItems() {
        return (PackageItems)this.getResponseItems();
    }

    public ReportItems getReportForReportName(String reportName) {
        ReportCache reportCache = this.getReportCache(reportName);
        return reportCache != null ? reportCache.getReportItems() : null;
    }

    protected ReportCache getReportCache(String reportName) {
        return (ReportCache)this.getContainer(reportName);
    }

    public ReportCache getReportCache(CachedResponse cachedResponse) {
        ReportItems reportItems = cachedResponse.getReportItems();
        String reportName = reportItems != null ? reportItems.getReportName() : null;
        return reportName != null ? this.getReportCache(reportName) : null;
    }

    public void saveCachedResponse(CachedResponse cachedResponse) {
        this.updateReportCache(cachedResponse);
        this.updatePackageItems(cachedResponse);
    }

    public void updateReportCache(CachedResponse cachedResponse) {
        String reportName;
        ReportItems reportItems = cachedResponse.getReportItems();
        String string = reportName = reportItems != null ? reportItems.getReportName() : null;
        if (reportName != null) {
            this.saveReport(reportName, reportItems, cachedResponse);
        }
    }

    private void saveReport(String reportName, ReportItems reportItems, CachedResponse cachedResponse) {
        ReportCache reportCache = this.getReportCache(reportName);
        if (reportCache == null) {
            this.addNewReportCache(reportName, reportItems);
        } else {
            reportCache.saveCachedResponse(cachedResponse);
        }
    }

    private void addNewReportCache(String reportName, ReportItems reportItems) {
        ReportCache reportCache = new ReportCache((CacheContainer)this, reportItems);
        this.saveReportCache(reportName, reportCache);
    }

    private void saveReportCache(String reportName, ReportCache reportCache) {
        this.saveChildContainer(reportName, reportCache);
    }

    public void updatePackageItems(CachedResponse responseFromCM) {
        PackageItems packageItemsFromTheCache;
        PackageItems packageItemsFromCM = responseFromCM.getPackageItems();
        if (packageItemsFromCM.hasCacheValidatorNewerThan(packageItemsFromTheCache = this.getPackageItems())) {
            this.usePackageItemsFromCM(packageItemsFromCM, packageItemsFromTheCache);
        } else {
            this.usePackageItemsFromTheCache(responseFromCM, packageItemsFromCM, packageItemsFromTheCache);
        }
    }

    private void usePackageItemsFromCM(PackageItems packageItemsFromCM, PackageItems packageItemsFromTheCache) {
        packageItemsFromCM.importPackageDataFromTheCache(packageItemsFromTheCache);
        this.setResponseItems(packageItemsFromCM);
    }

    private void usePackageItemsFromTheCache(CachedResponse responseFromCM, PackageItems packageItemsFromCM, PackageItems packageItemsFromTheCache) {
        packageItemsFromTheCache.importPackageDataFromCM(packageItemsFromCM);
        responseFromCM.setPackageItems(packageItemsFromTheCache);
    }

    @Override
    public void removeChildContainer(CacheContainer cacheContainer) {
        super.removeChildContainer(cacheContainer);
        this.notifyAccountCacheAboutRemovedReport(cacheContainer.getName());
    }

    private void notifyAccountCacheAboutRemovedReport(String reportName) {
        AccountCache accountCache = this.getParent();
        if (accountCache != null) {
            accountCache.notifyReportRemoved(reportName);
        }
    }

    @Override
    protected void renewCacheValidators(CachedResponse responseFromCM) {
        this.renewCacheValidators(responseFromCM.getPackageItems());
        this.renewCacheValidators(responseFromCM.getReportName(), responseFromCM);
    }

    @Override
    public void dump(PogoLogger log, String indent) {
        super.dump(log, indent, "Reports: ");
    }

    @Override
    public String toString() {
        return super.toString("Package");
    }
}

