/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.contentmanager.cache.CMCacheRequestBodyHandler;
import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.SearchType;
import com.cognos.pogo.contentmanager.cache.context.CacheContext;
import com.cognos.pogo.contentmanager.cache.level2.Level2Query;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.stax.connection.BusConnectionImpl;
import com.cognos.pogo.util.PogoLogger;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class QueryCacheElement {
    public static final String DISPATCHER_PATH = "/p2pd/servlet/dispatch";
    private static final String VALIDATE_CONTEXT = "validate";
    private CMCacheRequestBodyHandler requestBody;
    private boolean validate;
    private CacheContext cacheContext;
    private boolean isQueryingRemoteDispatcher;

    public static QueryCacheElement createInstance(Envelope requestEnvelope, String passport) {
        return new QueryCacheElement(requestEnvelope, passport);
    }

    private QueryCacheElement(Envelope requestEnvelope, String passport) {
        this.requestBody = (CMCacheRequestBodyHandler)requestEnvelope.getBodyHandler();
        this.processCacheContext(passport);
        if (this.needsToProcessCookies()) {
            this.processCookies(requestEnvelope);
        }
    }

    private void processCacheContext(String passport) {
        String contextValue = this.requestBody.getContextValue();
        if (contextValue != null) {
            if (StringUtils.equals((String)contextValue, (String)VALIDATE_CONTEXT)) {
                this.validate = true;
            } else {
                this.cacheContext = CacheContext.createCacheContextFromEncodedXML(contextValue, passport);
            }
        }
    }

    private boolean needsToProcessCookies() {
        return this.hasNoCacheContext() && !this.validate;
    }

    private void processCookies(Envelope requestEnvelope) {
        if (this.hasValidateCookie(requestEnvelope)) {
            this.validate = true;
        }
    }

    private boolean hasValidateCookie(Envelope requestEnvelope) {
        return requestEnvelope.getCookieValue("CogCacheService") != null;
    }

    public boolean needsToQueryCM(CachedResponse responseFromCache, SearchParameters searchParameters) {
        if (this.validate) {
            responseFromCache.expireLingerTime(searchParameters);
            return true;
        }
        if (!searchParameters.isSatisfiedBy(responseFromCache)) {
            return true;
        }
        if (responseFromCache.hasLingeringCacheValidator(searchParameters)) {
            return false;
        }
        return this.hasNoCacheContext() || this.cacheContext.hasNewerValidatorsThan(responseFromCache);
    }

    public CacheContext getCacheContext() {
        return this.cacheContext;
    }

    public boolean hasNoCacheContext() {
        return this.getCacheContext() == null;
    }

    public List<String> getItems() {
        return this.requestBody.getEntries().getItems();
    }

    public SearchParameters createSearchParameters() {
        SearchType searchType = this.getSearchType();
        if (searchType == SearchType.INVALID) {
            throw new RuntimeException("Invalid search type: " + searchType.getInvalidSearchType());
        }
        return new SearchParameters(searchType, this.getSearchPath());
    }

    private SearchType getSearchType() {
        return this.requestBody.getSearchType();
    }

    private String getSearchPath() {
        return this.requestBody.getObjectPath();
    }

    public NodeID getNodeID() {
        return this.isQueryingRemoteDispatcher() ? this.cacheContext.getNodeID() : null;
    }

    public String getQueryURL() {
        return this.isQueryingRemoteDispatcher() ? BusConnectionImpl.BUS_DISPATCHER : BusConnectionImpl.BUS_CM;
    }

    public boolean isQueryingRemoteDispatcher() {
        return this.isQueryingRemoteDispatcher;
    }

    public void setQueryTarget(Level2Query level2Query) {
        this.isQueryingRemoteDispatcher = this.cacheContext != null && this.cacheContext.isRemote() && this.cacheContext.hasValidatorsForAllQueries(level2Query) && level2Query.hasNoPackageHints();
    }

    public Level2Query createLevel2Query() {
        return new Level2Query();
    }

    public void dump(PogoLogger log, String indent) {
        log.debug(indent, this.getClass().getSimpleName(), ": ");
        indent = indent + "   ";
        log.debug(indent, "validate: ", this.validate);
        if (this.cacheContext != null) {
            this.cacheContext.dump(log, indent);
        }
    }
}

