/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.AccountCache;
import com.cognos.pogo.contentmanager.cache.AccountItems;
import com.cognos.pogo.contentmanager.cache.AccountTimer;
import com.cognos.pogo.contentmanager.cache.CacheCleaner;
import com.cognos.pogo.contentmanager.cache.CacheCleanerFactory;
import com.cognos.pogo.contentmanager.cache.CacheContainer;
import com.cognos.pogo.contentmanager.cache.CacheElement;
import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.HandlerConfig;
import com.cognos.pogo.contentmanager.cache.PackageItems;
import com.cognos.pogo.contentmanager.cache.ReportItems;
import com.cognos.pogo.contentmanager.cache.ResponseCacheCleanerFactory;
import com.cognos.pogo.contentmanager.cache.ResponseCacheCleanupThread;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.pool.MemoryUse;
import com.cognos.pogo.util.pool.StringPool;
import com.cognos.pogo.util.pool.StringPoolListener;
import com.cognos.pogo.util.pool.WeakHashPool;
import com.cognos.pogo.util.timer.PogoTime;
import java.util.LinkedList;
import java.util.List;
import org.apache.log.Priority;

public class ResponseCache
extends CacheContainer
implements StringPoolListener {
    private static PogoLogger log = PogoLogger.getLogger();
    private AccountTimer accountTimer;
    private long accountInactivityTimer = 900000L;
    private int heapLimit = 10;
    private final CacheCleanerFactory cacheCleanerFactory;
    private static final int initialStringPoolCapacity = 10000;
    private static final int alarmLevel = 80;

    public ResponseCache() {
        this(new PogoTime());
    }

    public ResponseCache(PogoTime cacheTime) {
        this(cacheTime, new WeakHashPool(10000));
    }

    public ResponseCache(PogoTime cacheTime, StringPool stringPool) {
        this(cacheTime, stringPool, new ResponseCacheCleanerFactory());
    }

    public ResponseCache(PogoTime cacheTime, StringPool stringPool, CacheCleanerFactory cacheCleanerFactory) {
        super(null, null);
        this.cacheCleanerFactory = cacheCleanerFactory;
        ResponseCache.setCacheTime(cacheTime);
        ResponseCache.setStringPool(stringPool);
        stringPool.setListener(this);
        this.setWaterLevel(stringPool, this.heapLimit);
        this.accountTimer = new AccountTimer(this);
    }

    private void setWaterLevel(StringPool stringPool, int maxHeapPercentage) {
        long maxCapacity = MemoryUse.getMaxSizeInBytes() * (long)maxHeapPercentage / 100L;
        stringPool.setWaterLevel(maxCapacity, 80);
    }

    public CachedResponse getCachedResponse(String passport, SearchParameters searchParameters) {
        AccountCache accountCache = this.getAccountCache(passport);
        return accountCache != null ? accountCache.getCachedResponse(searchParameters) : null;
    }

    public void put(String passport, CachedResponse cachedResponse) {
        AccountCache accountCache = this.getAccountCache(passport);
        if (accountCache == null) {
            accountCache = this.addNewAccountCache(passport, cachedResponse);
        }
        accountCache.saveCachedResponse(cachedResponse);
    }

    private AccountCache addNewAccountCache(String passport, CachedResponse cachedResponse) {
        AccountCache accountCache = new AccountCache((CacheContainer)this, cachedResponse.getAccountItems());
        this.saveAccountCache(passport, accountCache);
        return accountCache;
    }

    private void saveAccountCache(String passport, AccountCache accountCache) {
        this.scheduleTimeout(accountCache);
        this.saveChildContainer(passport, accountCache);
    }

    private void scheduleTimeout(AccountCache accountCache) {
        long timeout = this.getAccountInactivityTimer();
        log.debug("Scheduling timeout for account: ", accountCache, ", ", timeout, " ms");
        this.accountTimer.scheduleTimeoutEvent(accountCache, timeout);
    }

    public AccountItems getAccountItems(String passport) {
        AccountCache accountCache = this.getAccountCache(passport);
        return accountCache != null ? accountCache.getAccountItems() : null;
    }

    protected AccountCache getAccountCache(String passport) {
        return (AccountCache)this.getContainer(passport);
    }

    public PackageItems getPackageForPackageName(String passport, String packageName) {
        AccountCache accountCache = this.getAccountCache(passport);
        return accountCache != null ? accountCache.getPackageForPackageName(packageName) : null;
    }

    public ReportItems getReportForReportName(String passport, String packageName, String reportName) {
        AccountCache accountCache = this.getAccountCache(passport);
        return accountCache != null ? accountCache.getReportForReportName(packageName, reportName) : null;
    }

    @Override
    public void handleCapacityAlarm(int percentFull) {
        int percentToCleanup = percentFull / 10;
        ResponseCacheCleanupThread thread = new ResponseCacheCleanupThread(this, percentToCleanup);
        thread.start();
    }

    public void cleanupCache(int percentToCleanup) {
        CacheCleaner cacheCleaner = this.cacheCleanerFactory.createInstance();
        cacheCleaner.cleanupCache(percentToCleanup, this);
    }

    public List<CacheContainer> getAllCacheContainers() {
        LinkedList<CacheContainer> list = new LinkedList<CacheContainer>();
        this.addCacheContainersToList(list);
        return list;
    }

    @Override
    protected void renewCacheValidators(CachedResponse responseFromCM) {
        this.renewCacheValidators(responseFromCM.getPassport(), responseFromCM);
    }

    public void updateHeader(String passport, CachedResponse responseFromCM) {
        AccountItems accountItems = this.getAccountItems(passport);
        if (accountItems != null) {
            accountItems.setHeader(responseFromCM.getHeader());
        }
    }

    public int getNumberOfAccounts() {
        return this.getNumberOfInternalContainers();
    }

    public int getNumberOfPackages() {
        return this.getNumberOfSubContainers();
    }

    public int getNumberOfReports() {
        return this.getNumberOfSubSubContainers();
    }

    @Override
    public void dump(PogoLogger log, String indent) {
        CacheElement.disableAccessTimeUpdates();
        super.dump(log, indent, "Accounts: ");
        CacheElement.enableAccessTimeUpdates();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClassName());
        return sb.append("(Nr of accounts: ").append(this.getNumberOfAccounts()).append(')').toString();
    }

    public void updateConfiguration(HandlerConfig config) {
        this.updateHeapLimit(config);
        this.updateAccountInactivityTimer(config);
    }

    private void updateHeapLimit(HandlerConfig config) {
        int newHeapLimit = config.getHeapLimit();
        if (newHeapLimit != this.heapLimit) {
            this.setHeapLimit(newHeapLimit);
        }
    }

    public int getHeapLimit() {
        return this.heapLimit;
    }

    private void setHeapLimit(int heapLimit) {
        this.heapLimit = heapLimit;
        this.setWaterLevel(ResponseCache.getStringPool(), heapLimit);
    }

    private void updateAccountInactivityTimer(HandlerConfig config) {
        this.accountInactivityTimer = config.getAccountInactivityTimer();
    }

    public void handleAccountTimeout(AccountCache accountCache) {
        if (this.isAccountInactive(accountCache)) {
            this.removeInactiveAccount(accountCache);
        } else {
            this.rescheduleTimeout(accountCache);
        }
    }

    private boolean isAccountInactive(AccountCache accountCache) {
        return accountCache.getInactiveTime() >= this.getAccountInactivityTimer();
    }

    void removeInactiveAccount(AccountCache accountCache) {
        log.debug("Removing inactive account: ", accountCache);
        this.accountTimer.cancelTimeoutEvent(accountCache);
        this.removeChildContainer(accountCache);
    }

    private void rescheduleTimeout(AccountCache accountCache) {
        long newTimeout = this.getAccountInactivityTimer() - accountCache.getInactiveTime();
        log.debug("Rescheduling timeout for account: ", accountCache, ", ", newTimeout, " ms");
        this.accountTimer.scheduleTimeoutEvent(accountCache, newTimeout);
    }

    public long getAccountInactivityTimer() {
        return this.accountInactivityTimer;
    }

    protected void setAccountInactivityTimerForTesting(long accountInactivityTimer) {
        this.accountInactivityTimer = accountInactivityTimer;
    }

    protected void setAccountTimerForTesting(AccountTimer accountTimer) {
        this.accountTimer = accountTimer;
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }
}

