/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CacheContainer;
import com.cognos.pogo.contentmanager.cache.CacheValidator;
import com.cognos.pogo.contentmanager.cache.DatasourceSignons;
import com.cognos.pogo.contentmanager.cache.ItemStreamReaderDelegate;
import com.cognos.pogo.contentmanager.cache.KeyItems;
import com.cognos.pogo.contentmanager.cache.QueryResult;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.SoapTokens;
import com.cognos.pogo.contentmanager.cache.context.CacheContext;
import com.cognos.pogo.contentmanager.cache.level2.Level2Query;
import com.cognos.pogo.contentmanager.cache.level2.QueryRequest;
import com.cognos.pogo.contentmanager.cache.remote.RemoteDispatcherResponse;
import com.cognos.pogo.stax.stream.XMLStreamFactory;
import com.cognos.pogo.stax.utils.StaxUtils;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StreamFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.log.Priority;

public abstract class ResponseItems
extends KeyItems {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String namespaceURI = "http://www.w3.org/2001/XMLSchema-instance";
    private CacheValidator cacheValidator;
    private String responseName;
    private String responseId;
    private CacheContainer owner;

    public abstract String getQueryName(SearchParameters var1);

    protected abstract boolean isKeyItemName(String var1);

    public QueryResult getQueryResultFor(String itemName, SearchParameters searchParameters) {
        String item = this.getItem(itemName);
        return item != null ? new QueryResult(item) : QueryResult.NULL;
    }

    protected String getMainItemNameFor(String itemName) {
        return itemName;
    }

    public void parseResponse(String responseName, Map<String, String> attributes, XMLStreamReader reader) throws XMLStreamException {
        this.saveResponseAttributes(responseName, attributes);
        while (StaxUtils.moveToNextElementWithinParent("response", reader)) {
            this.parseResponse(reader);
        }
    }

    protected void parseResponse(XMLStreamReader reader) throws XMLStreamException {
        this.parseQueryResponse(reader);
    }

    protected void parseQueryResponse(XMLStreamReader reader) throws XMLStreamException {
        if ("queryResponse".equals(reader.getLocalName())) {
            while (StaxUtils.iterateChildrenElement("queryResult", reader)) {
                this.parseQueryResult(reader);
            }
        }
    }

    private void saveResponseAttributes(String responseName, Map<String, String> attributes) throws XMLStreamException {
        this.responseName = responseName;
        this.responseId = attributes.get("id");
        String searchPath = attributes.get("searchPath");
        if (searchPath != null) {
            this.setKey(searchPath);
        }
    }

    protected String getResponseName() {
        return this.responseName;
    }

    private void parseQueryResult(XMLStreamReader reader) throws XMLStreamException {
        while (StaxUtils.moveToNextElementWithinParent("queryResult", reader)) {
            this.parseRepliesOrCacheValidator(reader.getLocalName(), reader);
        }
    }

    private void parseRepliesOrCacheValidator(String localName, XMLStreamReader reader) throws XMLStreamException {
        if (localName.equals("replies")) {
            this.parseReplies(reader);
        } else if (localName.equals("cacheValidator")) {
            this.parseCacheValidator(reader);
        }
    }

    private void parseReplies(XMLStreamReader reader) throws XMLStreamException {
        while (StaxUtils.iterateChildrenElement("item", "type", "cm:queryReply", namespaceURI, reader)) {
            while (StaxUtils.iterateChildrenElement("queryResult", reader)) {
                while (StaxUtils.iterateChildrenElement("item", reader)) {
                    this.parseCurrentElement(reader);
                }
            }
        }
    }

    private void parseCurrentElement(XMLStreamReader reader) throws XMLStreamException {
        String itemName = this.getItemName(reader);
        this.parseAndSaveItem(itemName, reader);
    }

    private String getItemName(XMLStreamReader reader) {
        String cmType = reader.getAttributeValue(0);
        return this.removePrefix(cmType);
    }

    private String removePrefix(String cmType) {
        String cmPrefix = "cm:";
        return cmType.substring(cmPrefix.length());
    }

    protected void parseAndSaveItem(String itemName, XMLStreamReader reader) throws XMLStreamException {
        String itemBody = this.parseItemBody(itemName, reader);
        String mainItemName = this.getMainItemNameFor(itemName);
        this.saveItem(mainItemName, itemBody);
    }

    private String parseItemBody(String itemName, XMLStreamReader reader) throws XMLStreamException {
        String itemBody = this.needsSearchPath(itemName) ? this.getAndParseCurrentElement(itemName, reader) : this.getCurrentElement(reader);
        return itemBody;
    }

    private boolean needsSearchPath(String itemName) {
        return this.isKeyItemName(itemName) && this.hasNoSearchPath();
    }

    private boolean hasNoSearchPath() {
        return this.getKey() == null;
    }

    private String getAndParseCurrentElement(String itemName, XMLStreamReader reader) throws XMLStreamException {
        ItemStreamReaderDelegate itemReader = new ItemStreamReaderDelegate(reader);
        String itemBody = this.getCurrentElement(itemReader);
        this.setKey(itemReader.getSearchPath());
        return itemBody;
    }

    protected String getCurrentElement(XMLStreamReader reader) throws XMLStreamException {
        try {
            return this.getCurrentElement(reader, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getCurrentElement(XMLStreamReader reader, String encoding) throws UnsupportedEncodingException, XMLStreamException {
        ByteArrayOutputStream byteArrayOutputStream = StreamFactory.createByteArrayOutputStream();
        OutputStreamWriter writer = StreamFactory.createOutputStreamWriter(byteArrayOutputStream, encoding);
        XMLStreamWriter streamWriter = XMLStreamFactory.createXMLStreamWriter(writer);
        StaxUtils.copyCurrentElement(reader, streamWriter);
        return byteArrayOutputStream.toString(encoding);
    }

    protected List<String> getChildrenElements(String parent, XMLStreamReader reader) throws XMLStreamException {
        ArrayList<String> elements = new ArrayList<String>();
        while (StaxUtils.moveToNextElementWithinParent(parent, reader)) {
            String element = this.getCurrentElement(reader);
            elements.add(element);
        }
        return elements;
    }

    private void parseCacheValidator(XMLStreamReader reader) throws XMLStreamException {
        this.setCacheValidator(reader.getElementText());
    }

    protected void setCacheValidator(String cacheValidator) {
        this.cacheValidator = new CacheValidator(cacheValidator);
    }

    public String getCacheValidator() {
        return this.hasCacheValidator() ? this.cacheValidator.getValidator() : null;
    }

    public boolean hasCacheValidator() {
        return this.cacheValidator != null;
    }

    public boolean hasNoCacheValidator() {
        return this.cacheValidator == null;
    }

    public boolean hasLingeringCacheValidator() {
        return this.hasCacheValidator() && this.cacheValidator.isLingering();
    }

    public boolean hasAnExpiredCacheValidator() {
        return this.hasCacheValidator() && this.cacheValidator.isExpired();
    }

    public void renewCacheValidator(ResponseItems responseItemsFromCM) {
        if (this.hasCacheValidator()) {
            this.cacheValidator.resetExpiryTime();
            this.cacheValidator.resetLingerTime();
        }
    }

    @Override
    public ResponseItems getParent() {
        CacheContainer ownersParent = this.owner != null ? this.owner.getParent() : null;
        return ownersParent != null ? ownersParent.getResponseItems() : null;
    }

    public boolean hasCacheValidatorNewerThan(ResponseItems responseItemsInTheCache) {
        if (this.hasNoCacheValidator() || this.isSameObject(responseItemsInTheCache)) {
            return false;
        }
        CacheValidator validatorInTheCache = responseItemsInTheCache != null ? responseItemsInTheCache.cacheValidator : null;
        return validatorInTheCache == null || !validatorInTheCache.equals(this.cacheValidator);
    }

    private boolean isSameObject(ResponseItems responseItemsInTheCache) {
        return responseItemsInTheCache == this;
    }

    @Override
    public ResponseItems intern() {
        return (ResponseItems)super.intern();
    }

    @Override
    public void handleRemovalFromCache() {
        super.handleRemovalFromCache();
        this.setOwner(null);
    }

    public void setOwner(CacheContainer owner) {
        this.owner = owner;
    }

    public CacheContainer getOwner() {
        return this.owner;
    }

    public QueryRequest addRequestToQuery(Level2Query query, SearchParameters searchParameters, CacheContext cacheContext) {
        String queryName = this.getQueryName(searchParameters);
        QueryRequest request = query.addQueryRequest(queryName);
        this.setCacheValidator(request, cacheContext, queryName);
        return request;
    }

    private void setCacheValidator(QueryRequest request, CacheContext cacheContext, String queryName) {
        String validatorFromCacheContext = this.getValidatorFromCacheContext(cacheContext, queryName);
        String validatorFromCache = this.getCacheValidator();
        request.setCacheValidator(validatorFromCacheContext, validatorFromCache);
    }

    private String getValidatorFromCacheContext(CacheContext cacheContext, String queryName) {
        return cacheContext != null ? cacheContext.getCacheValidator(queryName, this.getKey()) : null;
    }

    public String getResponseId() {
        return this.responseId;
    }

    @Override
    public void dump(PogoLogger log, String indent) {
        super.dump(log, indent);
        indent = indent + "   ";
        log.debug(indent, "cacheValidator: ", this.cacheValidator);
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }

    public boolean canHandleQuery(String queryName, String searchPath) {
        return this.canHandleResponse(queryName) && StringUtils.equals((String)searchPath, (String)this.getKey());
    }

    public boolean canHandleResponse(String responseName) {
        return this.getQueryName(null).equals(responseName);
    }

    public void addToRemoteDispatcherResponse(RemoteDispatcherResponse response, QueryRequest queryRequest) {
        if (this.canUseShortResponse(queryRequest)) {
            this.addShortResponse(response, queryRequest);
        } else {
            this.addFullResponse(response, queryRequest);
        }
    }

    private boolean canUseShortResponse(QueryRequest queryRequest) {
        return this.hasSameCacheValidatorAs(queryRequest) && !this.hasAnExpiredCacheValidator();
    }

    private boolean hasSameCacheValidatorAs(QueryRequest queryRequest) {
        return StringUtils.equals((String)this.getCacheValidator(), (String)queryRequest.getCacheValidator());
    }

    private void addShortResponse(RemoteDispatcherResponse response, QueryRequest queryRequest) {
        response.addResponseLine(this.getResponseStartToken(queryRequest));
        response.addResponseLine(SoapTokens.getStartQueryResponse());
        this.addShortRepliesElement(response, queryRequest);
        this.addCacheValidatorElement(response);
        response.addResponseLine(SoapTokens.getEndQueryResponse());
        response.addResponseLine(this.getResponseEndToken(queryRequest));
    }

    private void addFullResponse(RemoteDispatcherResponse response, QueryRequest queryRequest) {
        response.addResponseLine(this.getResponseStartToken(queryRequest));
        response.addResponseLine(SoapTokens.getStartQueryResponse());
        this.addFullRepliesElement(response, queryRequest);
        this.addCacheValidatorElement(response);
        response.addResponseLine(SoapTokens.getEndQueryResponse());
        this.addHintsElement(response);
        response.addResponseLine(this.getResponseEndToken(queryRequest));
    }

    protected String getResponseStartToken(QueryRequest queryRequest) {
        StringBuilder sb = new StringBuilder("<response");
        this.addResponseAttributes(sb, queryRequest);
        return sb.append(">").toString();
    }

    protected void addResponseAttributes(StringBuilder sb, QueryRequest queryRequest) {
        this.addQueryNameAttribute(sb, queryRequest);
    }

    protected void addQueryNameAttribute(StringBuilder sb, QueryRequest queryRequest) {
        sb.append(" name=\"").append(queryRequest.getName()).append("\"");
    }

    protected void addShortRepliesElement(RemoteDispatcherResponse response, QueryRequest queryRequest) {
        response.addResponseLine(SoapTokens.getEmptyReplies());
    }

    protected void addCacheValidatorElement(RemoteDispatcherResponse response) {
        response.addResponseLine(SoapTokens.getStartCacheValidator());
        response.addResponseLine(this.getCacheValidator());
        response.addResponseLine(SoapTokens.getEndCacheValidator());
    }

    protected void addFullRepliesElement(RemoteDispatcherResponse response, QueryRequest queryRequest) {
    }

    protected void addItems(RemoteDispatcherResponse response, List<String> items) {
        for (String item : items) {
            this.addItem(response, item);
        }
    }

    protected void addItem(RemoteDispatcherResponse response, String item) {
        if (item == null) {
            response.addResponseLine(SoapTokens.getEmptyQueryResultElement());
        } else {
            response.addResponseLine(SoapTokens.getStartItemElement());
            response.addResponseLine(item);
            response.addResponseLine(SoapTokens.getEndItemElement());
        }
    }

    protected void addHintsElement(RemoteDispatcherResponse response) {
    }

    protected String getResponseEndToken(QueryRequest queryRequest) {
        return "</response>";
    }

    protected DatasourceSignons getDatasourceSignons() {
        return null;
    }

    public void expireLingerTime() {
        if (this.hasCacheValidator()) {
            this.cacheValidator.expireLingerTime();
        }
    }
}

