/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.SoapTokens;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.StringsEnvelope;
import java.util.ArrayList;
import java.util.List;

public abstract class ResponseToClient {
    private ArrayList<String> responseLines = new ArrayList();
    private final CachedResponse cachedResponse;

    public ResponseToClient(CachedResponse cachedResponse) {
        this.cachedResponse = cachedResponse;
    }

    private void buildResponseToClient() {
        this.startEnvelope();
        this.addSoapHeader();
        this.addSoapBody();
        this.endEnvelope();
    }

    private void startEnvelope() {
        this.addResponseLine(this.getStartSoapEnvelope());
    }

    protected void addResponseLine(String line) {
        this.responseLines.add(line);
    }

    protected void addResponseLines(List<String> lines) {
        this.responseLines.addAll(lines);
    }

    protected void addResponseLines(String ... lines) {
        for (String line : lines) {
            this.responseLines.add(line);
        }
    }

    protected String getStartSoapEnvelope() {
        return SoapTokens.getStartSoapEnvelope();
    }

    private void addSoapHeader() {
        this.addResponseLine(SoapTokens.getStartSoapHeader());
        this.addResponseLine(this.cachedResponse.getHeader());
        this.addResponseLine(SoapTokens.getEndSoapHeader());
    }

    private void addSoapBody() {
        this.addResponseLine(SoapTokens.getStartSoapBody());
        this.addSoapBodyContents();
        this.addResponseLine(SoapTokens.getEndSoapBody());
    }

    protected abstract void addSoapBodyContents();

    private void endEnvelope() {
        this.addResponseLine(SoapTokens.getEndSoapEnvelope());
    }

    public SOAPEnvelope getEnvelope() {
        if (this.responseLines.isEmpty()) {
            this.buildResponseToClient();
        }
        return new StringsEnvelope(this.responseLines);
    }

    protected CachedResponse getCachedResponse() {
        return this.cachedResponse;
    }
}

