/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

public class SearchPathUtils {
    public static final int NOT_FOUND = -1;
    private static final String MODEL_NAME = "/model[";
    private static final String MODEL_VIEW_NAME = "/modelView[";
    private static final String[] DATASOURCESIGNON_NAMES = new String[]{"/dataSourceSignon(", "/personalDataSourceSignon("};

    public static String getModelName(String searchPath) {
        int slashPos = searchPath.indexOf(MODEL_NAME);
        int namePos = slashPos + 1;
        return searchPath.substring(namePos);
    }

    public static String getModelViewName(String searchPath) {
        int slashPos = searchPath.indexOf(MODEL_VIEW_NAME);
        int namePos = slashPos + 1;
        return searchPath.substring(namePos);
    }

    public static String getModelFromModelView(String modelViewSearchPath) {
        int slashPos = modelViewSearchPath.indexOf(MODEL_VIEW_NAME);
        return modelViewSearchPath.substring(0, slashPos);
    }

    public static String getPackageFromModel(String modelSearchPath) {
        int slashPos = modelSearchPath.indexOf(MODEL_NAME);
        return modelSearchPath.substring(0, slashPos);
    }

    public static String getDatasourceSignonSearchPath(String searchPath) {
        int slashPos = SearchPathUtils.findDatasourceSignonIndexInSearchPath(searchPath);
        int namePos = slashPos + 1;
        return searchPath.substring(namePos);
    }

    private static int findDatasourceSignonIndexInSearchPath(String searchPath) {
        for (String name : DATASOURCESIGNON_NAMES) {
            int index = searchPath.indexOf(name);
            if (index < 0) continue;
            return index;
        }
        return -1;
    }

    public static String getPackageFromDatasourceSignon(String datasourceSignonSearchPath) {
        int slashPos = SearchPathUtils.findDatasourceSignonIndexInSearchPath(datasourceSignonSearchPath);
        return datasourceSignonSearchPath.substring(0, slashPos);
    }
}

