/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache.context;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.ResponseItems;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.context.CacheContextValidator;
import com.cognos.pogo.contentmanager.cache.level2.Level2Query;
import com.cognos.pogo.contentmanager.cache.level2.QueryRequest;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CacheContext {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final int FIRST_VALIDATOR = 1;
    private static final int FIELDS_PER_VALIDATOR = 3;
    public static final String FIELD_SEPARATOR = "__!%%!__";
    private static final String[] NO_FIELDS = new String[0];
    private static String localNodeID;
    private StringBuilder sb = new StringBuilder();
    private NodeID nodeID;
    private List<CacheContextValidator> validators = new ArrayList<CacheContextValidator>();

    public static CacheContext createEmptyCacheContext() {
        return new CacheContext();
    }

    private CacheContext() {
    }

    public static CacheContext createCacheContextFromEncodedXML(String encodedXML, String passport) {
        return StringUtils.isEmpty((String)encodedXML) ? null : CacheContext.createAndValidateCacheContext(encodedXML, passport);
    }

    private static CacheContext createAndValidateCacheContext(String encodedXML, String passport) {
        CacheContext cacheContext = new CacheContext(encodedXML);
        if (cacheContext.validatePassport(passport)) {
            return cacheContext;
        }
        log.warn("Ignoring invalid cache context [", encodedXML, "] for passport: ", passport);
        return null;
    }

    private CacheContext(String encodedXml) {
        this.sb.append(encodedXml);
        this.parse();
    }

    private boolean validatePassport(String passport) {
        for (CacheContextValidator validator : this.validators) {
            if (!validator.canValidatePassport()) continue;
            return validator.validatePassport(passport);
        }
        return true;
    }

    public void parse() {
        String[] fields = this.getFields();
        this.extractNodeID(fields);
        this.extractValidators(fields);
    }

    private String[] getFields() {
        String decodedXml = XmlUtils.xmlDecode(this.sb.toString());
        return decodedXml != null ? decodedXml.split(FIELD_SEPARATOR) : NO_FIELDS;
    }

    private void extractNodeID(String[] fields) {
        if (fields.length > 0) {
            this.nodeID = NodeID.getNodeID(fields[0]);
        }
    }

    private void extractValidators(String[] fields) {
        int currentValidator = 1;
        while (this.hasEnoughFieldsRemaining(fields, currentValidator)) {
            this.extractValidator(fields, currentValidator);
            currentValidator = this.nextValidator(currentValidator);
        }
    }

    private boolean hasEnoughFieldsRemaining(String[] fields, int current) {
        return current <= fields.length - 3;
    }

    private void extractValidator(String[] fields, int current) {
        String queryName = fields[current];
        String searchPath = fields[current + 1];
        String cacheValidator = fields[current + 2];
        this.validators.add(new CacheContextValidator(queryName, searchPath, cacheValidator));
    }

    private int nextValidator(int current) {
        return current + 3;
    }

    public static CacheContext createLocalCacheContext(String ... strings) {
        CacheContext cacheContext = CacheContext.createEmptyCacheContext();
        cacheContext.addLocalNodeID();
        cacheContext.addFields(strings);
        cacheContext.parse();
        return cacheContext;
    }

    public static CacheContext createRemoteCacheContext(String ... strings) {
        CacheContext cacheContext = CacheContext.createEmptyCacheContext();
        cacheContext.addFields(strings);
        cacheContext.parse();
        return cacheContext;
    }

    public void addLocalNodeID() {
        this.addField(CacheContext.getLocalNodeID());
    }

    public void addField(String field) {
        if (field != null) {
            XmlUtils.xmlEncodeElement(field, this.sb).append(FIELD_SEPARATOR);
        }
    }

    public void addFields(String ... strings) {
        for (String string : strings) {
            this.addField(string);
        }
    }

    public static String getLocalNodeID() {
        if (localNodeID == null) {
            localNodeID = NodeID.getSelf().getURI();
        }
        return localNodeID;
    }

    public static void setLocalNodeIdForTesting(String localNodeID) {
        CacheContext.localNodeID = localNodeID;
    }

    public void addResponseItems(ResponseItems responseItems, SearchParameters searchParameters) {
        if (responseItems == null || responseItems.getKey() == null) {
            return;
        }
        this.addField(responseItems.getQueryName(searchParameters));
        this.addField(responseItems.getKeyForCacheContext());
        this.addField(responseItems.getCacheValidator());
    }

    public NodeID getNodeID() {
        return this.nodeID;
    }

    public String getCacheValidator(String name, String searchPath) {
        for (CacheContextValidator validator : this.validators) {
            if (!validator.hasSame(name, searchPath)) continue;
            return validator.getCacheValidator();
        }
        return null;
    }

    public boolean hasNewerValidatorsThan(CachedResponse responseFromCache) {
        if (this.isRemote()) {
            for (CacheContextValidator validator : this.validators) {
                if (!validator.isNewerThan(responseFromCache)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasValidatorsForAllQueries(Level2Query level2Query) {
        for (QueryRequest queryRequest : level2Query.getQueryRequests()) {
            if (this.hasCacheValidatorFor(queryRequest)) continue;
            return false;
        }
        return true;
    }

    private boolean hasCacheValidatorFor(QueryRequest queryRequest) {
        for (CacheContextValidator validator : this.validators) {
            if (!validator.worksFor(queryRequest)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPassport(String passport) {
        for (CacheContextValidator validator : this.validators) {
            if (!validator.hasSearchPath(passport)) continue;
            return true;
        }
        return false;
    }

    public boolean isRemote() {
        return this.nodeID != null && !this.nodeID.isSelf();
    }

    public String toString() {
        return this.sb.toString();
    }

    public void dump(PogoLogger log, String indent) {
        log.debug(indent, this.getClass().getSimpleName(), ": ");
        indent = indent + "   ";
        log.debug(indent, "localNodeID (static): ", CacheContext.getLocalNodeID());
        log.debug(indent, "nodeID: ", this.nodeID);
        for (CacheContextValidator validator : this.validators) {
            validator.dump(log, indent);
        }
    }
}

