/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache.context;

import com.cognos.pogo.contentmanager.cache.AccountItems;
import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.ResponseItems;
import com.cognos.pogo.contentmanager.cache.level2.QueryRequest;
import com.cognos.pogo.util.PogoLogger;
import org.apache.commons.lang.StringUtils;

public class CacheContextValidator {
    private String queryName;
    private String searchPath;
    private String cacheValidator;

    public CacheContextValidator(String queryName, String searchPath, String cacheValidator) {
        this.queryName = queryName;
        this.searchPath = searchPath;
        this.cacheValidator = cacheValidator;
    }

    public boolean hasSame(String queryName, String searchPath) {
        return this.hasQueryName(queryName) && this.hasSearchPath(searchPath);
    }

    public boolean hasQueryName(String queryName) {
        return StringUtils.equals((String)this.queryName, (String)queryName);
    }

    public boolean hasSearchPath(String searchPath) {
        return StringUtils.equals((String)this.searchPath, (String)searchPath);
    }

    public boolean canValidatePassport() {
        return AccountItems.isAccountQuery(this.queryName);
    }

    public boolean validatePassport(String passport) {
        if (this.failsChecksum(passport)) {
            return false;
        }
        this.searchPath = passport;
        return true;
    }

    private boolean failsChecksum(String passport) {
        return !AccountItems.getChecksumFor(passport).equals(this.searchPath);
    }

    public String getCacheValidator() {
        return this.cacheValidator;
    }

    public boolean isNewerThan(CachedResponse responseFromCache) {
        ResponseItems responseItems = responseFromCache.getResponseItemsFor(this.queryName, this.searchPath);
        return responseItems != null && this.isNewerThan(responseItems);
    }

    private boolean isNewerThan(ResponseItems responseItems) {
        return !StringUtils.equals((String)responseItems.getCacheValidator(), (String)this.cacheValidator);
    }

    public boolean worksFor(QueryRequest queryRequest) {
        String querySearchPath = queryRequest.getSearchPath();
        if (querySearchPath == null) {
            return this.hasQueryName(queryRequest.getName());
        }
        return this.hasQueryName(queryRequest.getName()) && this.hasSearchPath(querySearchPath);
    }

    public void dump(PogoLogger log, String indent) {
        log.debug(indent, this.getClass().getSimpleName(), ": ");
        indent = indent + "   ";
        log.debug(indent, "queryName: ", this.queryName);
        log.debug(indent, "searchPath: ", this.searchPath);
        log.debug(indent, "cacheValidator: ", this.cacheValidator);
    }
}

