/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache.remote;

import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.DispatcherSession;
import com.cognos.pogo.contentmanager.cache.HandlerConfig;
import com.cognos.pogo.contentmanager.cache.ResponseCache;
import com.cognos.pogo.contentmanager.cache.remote.RemoteDispatcherRequest;
import com.cognos.pogo.contentmanager.cache.remote.RemoteDispatcherResponse;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.PerfLogger;
import com.cognos.pogo.util.PerfTimer;
import com.cognos.pogo.util.PogoLogger;

public class RemoteDispatcherSession
extends DispatcherSession {
    private static final PogoLogger log = PogoLogger.getLogger();
    private CachedResponse responseFromCache;
    private RemoteDispatcherRequest remoteDispatcherRequest;

    public RemoteDispatcherSession(MessageContext messageContext, ResponseCache responseCache, HandlerConfig hc) {
        super(messageContext, responseCache, hc);
    }

    @Override
    protected PogoLogger getLog() {
        return log;
    }

    @Override
    protected String getRequestName() {
        return "contentManagerCacheService (remote)";
    }

    @Override
    protected void processRequest() {
        this.queryResponseCache();
        this.createResponseToRemoteDispatcher();
    }

    @Override
    protected void createSearchParameters() {
        this.remoteDispatcherRequest = RemoteDispatcherRequest.createInstance(this.getRequestEnvelope());
        this.setSearchParameters(this.remoteDispatcherRequest.createSearchParameters());
    }

    @Override
    protected void logRequest() {
        log.debug("Handling remote dispatcher request: ", this.getRequestEnvelope());
        this.remoteDispatcherRequest.dump(log, "");
        this.getSearchParameters().dump(log, "");
    }

    private void queryResponseCache() {
        PerfTimer timer = this.startPerfTimer(PerfLogger.Level.LEVEL3, "queryResponseCache", this.getSearchParameters().getObjectPath());
        this.responseFromCache = this.getResponseCache().getCachedResponse(this.getPassport(), this.getSearchParameters());
        this.stopPerfTimer(timer);
    }

    private void createResponseToRemoteDispatcher() {
        PerfTimer timer = this.startPerfTimer(PerfLogger.Level.LEVEL4, "createResponseToRemoteDispatcher", new Object[0]);
        if (this.responseFromCache == null) {
            this.sendSoapFault("Data not found in remote dispatcher cache", null);
        } else {
            this.createSuccessfulResponse();
        }
        this.stopPerfTimer(timer);
    }

    private void createSuccessfulResponse() {
        RemoteDispatcherResponse response = new RemoteDispatcherResponse(this.remoteDispatcherRequest, this.responseFromCache);
        this.setResponseEnvelope(response.getEnvelope());
    }
}

