/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.config;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.impl.DispatcherStrings;
import java.util.NoSuchElementException;
import org.dom4j.Element;

public class DispatcherConfiguration {
    private String dispatcherPath = "";
    private String state = "";

    public DispatcherConfiguration(String newDispatcherPath) throws CommandExecutionException {
        this.dispatcherPath = newDispatcherPath;
        this.load();
    }

    public String getState() {
        return this.state;
    }

    private void setState(String newState) {
        this.state = newState;
    }

    public void load() throws CommandExecutionException {
        ContentManagerQueryCommand query = new ContentManagerQueryCommand(this.dispatcherPath);
        query.addQueryPropertyName("configuration");
        query.addQueryPropertyName("version");
        query.setDoTrustedRequest(true);
        query.execute();
        try {
            CMClass configurationClass = query.getFirstResultClass();
            String className = configurationClass.getCMClassName();
            if (!"dispatcher".equals(className)) {
                Object[] args = new Object[]{this.dispatcherPath, className, "dispatcher"};
                String errorMsg = DispatcherStrings.getInstance().getString("DispatcherConfiguration.wrongObjectType", args);
                throw new CommandExecutionException(errorMsg);
            }
            Element configurationElement = configurationClass.getPropertyAsElement("configuration");
            Element configDataElement = configurationElement.element("configData");
            this.setState(configDataElement.attributeValue("state"));
        }
        catch (NoSuchElementException ex) {
            Object[] args = new Object[]{this.dispatcherPath};
            String errorMsg = DispatcherStrings.getInstance().getString("DispatcherConfiguration.objectNotFound", args);
            throw new CommandExecutionException(errorMsg);
        }
    }
}

