/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.coordinator;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.contentmanager.coordinator.ActiveCMControl;
import com.cognos.pogo.contentmanager.coordinator.BootstrapConfigurePublishInt;
import com.cognos.pogo.contentmanager.coordinator.CMBootstrap;
import com.cognos.pogo.contentmanager.coordinator.RefreshController;
import com.cognos.pogo.logging.LoggingContext;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeTimerTask;
import java.util.Timer;
import java.util.TimerTask;
import org.dom4j.Element;

public class BootstrapConfigurePublish
implements BootstrapConfigurePublishInt {
    static final PogoLogger cat = PogoLogger.getLogger();
    static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    private RefreshController refreshController;
    private CMBootstrap bootstrap;
    private long checkingInterval = 30000L;
    private Timer configurationCheckTimer;

    public BootstrapConfigurePublish(PogoEngine engine, String pubName) {
        this(engine, pubName, new CMBootstrap(engine));
    }

    public BootstrapConfigurePublish(PogoEngine engine, String pubName, CMBootstrap cmBootstrap) {
        String dispatcherName = PropertyInserter.getProperty("dispatcher.name");
        this.bootstrap = cmBootstrap;
        this.refreshController = new RefreshController(dispatcherName, engine);
    }

    @Override
    public void start() {
        try {
            this.setLoggingContext();
            this.checkRegistration();
            this.startConfigurationChecking();
        }
        catch (Exception e) {
            cat.error("Error configuring ", e);
        }
    }

    @Override
    public void stop() {
        try {
            this.stopConfigurationChecking();
        }
        catch (Exception e) {
            cat.debug("Error stopping ", e);
        }
    }

    private void setLoggingContext() {
        LoggingContext loggingContext = loggingRealm.getLoggingContext();
        loggingContext.setSessionID("BootstrapConfigurePublish");
        loggingContext.setStepID("0");
        loggingContext.setRequestID("na");
        loggingContext.setSubRequestID("");
    }

    @Override
    public void changeCM() {
        try {
            this.checkRegistration();
            this.refreshController.run();
        }
        catch (Exception e) {
            cat.info("Error changing CM ", e);
        }
    }

    private void checkRegistration() throws Exception {
        this.bootstrap.run();
    }

    @Override
    public void setCheckingInterval(long newCheckingInterval) {
        long oldCheckingInterval = this.checkingInterval;
        this.checkingInterval = newCheckingInterval;
        if (oldCheckingInterval != newCheckingInterval) {
            cat.debug("Changing checking interval from ", oldCheckingInterval, " to ", newCheckingInterval);
            this.cancelTimer();
            this.startConfigurationChecking();
        }
    }

    private void cancelTimer() {
        if (this.configurationCheckTimer != null) {
            cat.debug("Stopping configuration check");
            this.configurationCheckTimer.cancel();
        }
    }

    private void startConfigurationChecking() {
        this.configurationCheckTimer = this.getNewTimer();
        this.configurationCheckTimer.schedule((TimerTask)new ConfigurationCheckTask(), 0L, this.checkingInterval);
        cat.debug("Configuration Checking at interval: ", this.checkingInterval);
    }

    private void stopConfigurationChecking() {
        this.cancelTimer();
    }

    protected Timer getNewTimer() {
        return new Timer(true);
    }

    public void cmErrorNotify(boolean ok) {
        if (ok) {
            ActiveCMControl.getInstance().cMOkNotify();
        } else {
            ActiveCMControl.getInstance().cMIOErrorNotify();
        }
    }

    private void checkConfiguration() {
        try {
            if (this.checkConfigurationChanged()) {
                this.startConfiguration();
            }
        }
        catch (Exception e) {
            cat.debug("Exception while checking configuration: ", e);
        }
    }

    private boolean checkConfigurationChanged() throws CommandExecutionException {
        ContentManagerQueryCommand command = new ContentManagerQueryCommand("/configuration");
        command.addQueryPropertyName("lastConfigurationModificationTime");
        command.setDoTrustedRequest(true);
        command.execute();
        Element queryResponseElement = command.getQueryResponseElement();
        return this.checkModificationTime(queryResponseElement);
    }

    private boolean checkModificationTime(Element responseElement) {
        Element lcm = (Element)responseElement.selectSingleNode("//lastConfigurationModificationTime/value");
        return this.refreshController.checkTime(lcm.getTextTrim());
    }

    private void startConfiguration() throws Exception {
        this.refreshController.run();
        if (this.refreshController.isUnregisteredDispatcher()) {
            this.checkRegistration();
        }
    }

    RefreshController getRefreshController() {
        return this.refreshController;
    }

    public class ConfigurationCheckTask
    extends SafeTimerTask {
        public ConfigurationCheckTask() {
            super("checkConfiguration");
        }

        @Override
        public void safeRun() {
            BootstrapConfigurePublish.this.checkConfiguration();
        }
    }
}

